/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.actions.TilesAction;
import org.intermine.metadata.StringUtil;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathQuery;
import org.intermine.web.logic.WebUtil;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.http.TableExporterFactory;
import org.intermine.web.logic.export.http.TableHttpExporter;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.session.SessionMethods;

public class ExportOptionsController
extends TilesAction {
    private static final Logger LOG = Logger.getLogger(ExportOptionsController.class);

    public ActionForward execute(ComponentContext context, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        String type = request.getParameter("type");
        String table = request.getParameter("table");
        PagedTable pt = SessionMethods.getResultsTable((HttpSession)session, (String)table);
        if (pt == null) {
            LOG.error((Object)("PagedTable for " + table + " is null"));
            return null;
        }
        WebConfig webConfig = SessionMethods.getWebConfig((HttpServletRequest)request);
        TableExporterFactory factory = new TableExporterFactory(webConfig);
        try {
            TableHttpExporter exporter = factory.getExporter(type);
            List initialPaths = exporter.getInitialExportPaths(pt);
            LinkedHashMap<String, String> pathsMap = new LinkedHashMap<String, String>();
            PathQuery query = pt.getWebTable().getPathQuery();
            for (Path path : initialPaths) {
                String pathString = path.toStringNoConstraints();
                String title = query.getGeneratedPathDescription(pathString);
                title = WebUtil.formatColumnName((String)title);
                pathsMap.put(pathString, title);
            }
            request.setAttribute("pathsMap", pathsMap);
            String pathStrings = StringUtil.join(pathsMap.keySet(), (String)" ");
            request.setAttribute("pathsString", (Object)pathStrings);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception", (Throwable)e);
            SessionMethods.recordError((String)("An internal error has occured while creating the export options page: " + e.getMessage()), (HttpSession)session);
        }
        request.setAttribute("table", (Object)table);
        request.setAttribute("type", (Object)type);
        return null;
    }
}

