/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.struts.InterMineAction;

public class FileDownloadAction
extends InterMineAction {
    private static final Logger LOG = Logger.getLogger(FileDownloadAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            int bytesRead;
            String path = request.getParameter("path");
            String fileName = request.getParameter("fileName");
            String mimeType = request.getParameter("mimeType");
            String mimeExtension = request.getParameter("mimeExtension");
            if (!this.fileIsPermitted(fileName)) {
                response.sendError(401);
                return null;
            }
            InputStream is = this.getServlet().getServletContext().getResourceAsStream(path + fileName);
            if (is == null) {
                response.sendError(404);
                return null;
            }
            if (fileName.endsWith(mimeExtension)) {
                response.setContentType(mimeType);
                response.setHeader("Content-disposition", "attachment; filename=" + fileName);
            }
            ServletOutputStream sos = response.getOutputStream();
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = is.read(buff, 0, buff.length))) {
                sos.write(buff, 0, bytesRead);
            }
            is.close();
            sos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.recordError(new ActionMessage("api.fileDownloadFailed"), request);
            return mapping.findForward("api");
        }
        return null;
    }

    private boolean fileIsPermitted(String fileName) {
        String[] blackList;
        if (fileName == null) {
            return false;
        }
        Properties webProps = InterMineContext.getWebProperties();
        for (String notAllowed : blackList = webProps.getProperty("web.download.blacklist").split(",")) {
            if (!fileName.contains(notAllowed)) continue;
            LOG.info((Object)("Request denied due to black-list entry: " + fileName + " contains " + notAllowed));
            return false;
        }
        Object[] whiteList = webProps.getProperty("web.download.whitelist").split(",");
        if (whiteList.length > 0) {
            for (String string : whiteList) {
                if (!fileName.contains(string)) continue;
                return true;
            }
            LOG.info((Object)("Request denied due to white-list: " + fileName + " does not contain any of " + StringUtils.join((Object[])whiteList)));
            return false;
        }
        return true;
    }
}

