/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForward;

public class ForwardParameters {
    private static final Logger LOG = Logger.getLogger(ForwardParameters.class);
    protected ActionForward af;
    protected Map<String, String> params = new LinkedHashMap();
    protected String anchor;

    public ForwardParameters(ActionForward af) {
        this.af = af;
    }

    public ForwardParameters(String path, boolean redirect) {
        this.af = new ActionForward(path, redirect);
    }

    public ForwardParameters addParameter(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public ForwardParameters addAnchor(String newAnchor) {
        this.anchor = newAnchor;
        return this;
    }

    public ActionForward forward() {
        String path = "";
        for (Map.Entry entry : this.params.entrySet()) {
            if (path.length() > 0) {
                path = path + "&";
            }
            try {
                path = path + (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException err) {
                LOG.error((Object)"Shouldn't ever happen", (Throwable)err);
                throw new RuntimeException("Shouldn't ever happen", err);
            }
        }
        if (path.length() > 0) {
            path = "?" + path;
        }
        if (this.anchor != null) {
            path = path + "#" + this.anchor;
        }
        return new ActionForward(this.af.getPath() + path, this.af.getRedirect());
    }
}

