/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.Reader;
import java.io.StringReader;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.TagManager;
import org.intermine.api.search.ChangeEvent;
import org.intermine.api.search.MassTaggingEvent;
import org.intermine.api.xml.TagBinding;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ImportTagsForm;
import org.intermine.web.struts.InterMineAction;

public class ImportTagsAction
extends InterMineAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ImportTagsForm f = (ImportTagsForm)form;
        HttpSession session = request.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        ProfileManager pm = im.getProfileManager();
        if (f.isOverwriting()) {
            TagManager tm = im.getTagManager();
            tm.deleteTags(null, null, null, profile.getUsername());
        }
        StringReader reader = new StringReader(f.getXml());
        int count = 0;
        if (!StringUtils.isEmpty((String)f.getXml())) {
            try {
                count = new TagBinding().unmarshal(pm, profile.getUsername(), (Reader)reader);
            }
            catch (Exception ex) {
                SessionMethods.recordError((String)"Problems importing tags. Please check the XML structure.", (HttpSession)session);
                return mapping.findForward("importTag");
            }
        }
        this.recordMessage(new ActionMessage("history.importedTags", (Object)new Integer(count)), request);
        if (count > 0) {
            MassTaggingEvent e = new MassTaggingEvent();
            profile.getSearchRepository().receiveEvent((ChangeEvent)e);
            if (SessionMethods.isSuperUser((HttpSession)session)) {
                SessionMethods.getGlobalSearchRepository((ServletContext)session.getServletContext()).receiveEvent((ChangeEvent)e);
            }
        }
        f.reset();
        profile.invalidateTemplateCacheIfRequired();
        return mapping.findForward("success");
    }
}

