/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.tiles.TilesRequestProcessor;
import org.apache.struts.util.MessageResources;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.web.logic.session.SessionMethods;

public class InterMineRequestProcessor
extends TilesRequestProcessor {
    private static final Logger LOG = Logger.getLogger(InterMineRequestProcessor.class);
    private static final String LOGON_PATH = "/begin";
    private static final String LOGON_INIT_PATH = "/initBegin";
    public static final List<String> START_PATHS = Arrays.asList("/begin", "/initBegin", "/classChooser", "/bagBuild", "/report", "/examples", "/browseAction", "/collectionDetails", "/iqlQuery", "/login", "/contact", "/portal", "/templates", "/templateSearch", "/template", "/aspect", "/ping", "/standalone", "/quickStart", "/importQuery", "/tree", "/headMenu", "/htmlHead", "/dataCategories", "/bagDetails", "/results", "/passwordReset", "/experiment", "/features", "/loadQuery", "/loadTemplate", "/customQuery", "/importQueries", "/bag", "/keywordSearchResults");
    private final Set<String> bots = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("slurp", "bot", "spider", "crawl", "scooter", "ezooms", "archiver", "eventbox", "docomo", "nutch", "grabber")));

    protected boolean processPreprocess(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        if (SessionMethods.isErrorOnInitialiser((ServletContext)request.getSession().getServletContext())) {
            return true;
        }
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)session);
        try {
            Profile profile;
            String processPath = this.processPath(request, response);
            if (processPath.startsWith("/standalone")) {
                return true;
            }
            String userAgent = null;
            if (request.getHeader("user-agent") != null) {
                userAgent = request.getHeader("user-agent").toLowerCase();
            }
            if ((profile = SessionMethods.getProfile((HttpSession)session)) == null) {
                session.invalidate();
                profile = SessionMethods.getProfile((HttpSession)session);
            }
            if (userAgent != null && !profile.isLoggedIn()) {
                for (String bot : this.bots) {
                    if (!userAgent.contains(bot)) continue;
                    session.setMaxInactiveInterval(60);
                    break;
                }
            }
            ProfileManager pm = im.getProfileManager();
            if (session.getAttribute("ser") != null) {
                String queryXml;
                session.removeAttribute("ser");
                SessionMethods.initSession((HttpSession)session);
                String user = (String)session.getAttribute("ser-username");
                if (user != null) {
                    Profile p = pm.getProfile(user);
                    if (p != null) {
                        LOG.warn((Object)("Could not find profile for user " + user));
                        SessionMethods.setProfile((HttpSession)session, (Profile)profile);
                    }
                    session.removeAttribute("ser-username");
                }
                if ((queryXml = (String)session.getAttribute("ser-query")) != null) {
                    BagManager bagManager = im.getBagManager();
                    Map allBags = bagManager.getBags(profile);
                    PathQuery pq = PathQueryBinding.unmarshalPathQuery((Reader)new StringReader(queryXml), (int)2);
                    HashSet<String> missingBags = new HashSet<String>();
                    for (String bagName : pq.getBagNames()) {
                        if (allBags.containsKey(bagName)) continue;
                        missingBags.add(bagName);
                    }
                    if (!pq.isValid()) {
                        LOG.warn((Object)("PathQuery XML in saved session invalid! " + queryXml));
                    } else if (!missingBags.isEmpty()) {
                        LOG.warn((Object)("PathQuery XML in saved session references bags that don't exist: " + missingBags + " query: " + queryXml));
                    } else {
                        SessionMethods.setQuery((HttpSession)session, (PathQuery)pq);
                    }
                    session.removeAttribute("ser-query");
                }
            }
            if (!(request.isRequestedSessionIdValid() || request.getAttribute("org.apache.struts.action.ACTION_MESSAGE") != null || START_PATHS.contains(processPath) || processPath.startsWith("/init"))) {
                ActionMessages messages = new ActionMessages();
                messages.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("errors.session.nosession"));
                request.setAttribute("org.apache.struts.action.ERROR", (Object)messages);
                this.processForwardConfig(request, response, (ForwardConfig)new ActionForward("/begin.do", true));
            }
        }
        catch (Exception e) {
            request.getSession().invalidate();
            throw new RuntimeException(e);
        }
        return true;
    }

    protected void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward) throws IOException, ServletException {
        ForwardConfig forwardConfig = forward;
        ActionMessages messages = (ActionMessages)request.getAttribute("org.apache.struts.action.ACTION_MESSAGE");
        ActionMessages errors = (ActionMessages)request.getAttribute("org.apache.struts.action.ERROR");
        if (forwardConfig != null && forwardConfig.getRedirect()) {
            String params;
            String msg;
            ActionMessage message;
            Iterator iter;
            MessageResources resources = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
            if (errors != null && !errors.isEmpty()) {
                iter = errors.get();
                while (iter.hasNext()) {
                    message = (ActionMessage)iter.next();
                    msg = resources.getMessage(message.getKey(), message.getValues());
                    SessionMethods.recordError((String)msg, (HttpSession)request.getSession());
                }
            }
            if (messages != null && !messages.isEmpty()) {
                iter = messages.get();
                while (iter.hasNext()) {
                    message = (ActionMessage)iter.next();
                    msg = resources.getMessage(message.getKey(), message.getValues());
                    SessionMethods.recordMessage((String)msg, (HttpSession)request.getSession());
                }
            }
            if ((params = request.getParameter("__intermine_forward_params__")) != null) {
                String path = forwardConfig.getPath();
                path = path.indexOf(63) != -1 ? path + "&" + params : path + "?" + params;
                forwardConfig = new ForwardConfig("dummy", path, true);
            }
        }
        super.processForwardConfig(request, response, forwardConfig);
    }
}

