/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.SavedQuery;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.util.XmlUtil;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.ForwardParameters;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.ModifyQueryForm;

public class ModifyQueryAction
extends InterMineAction {
    private static final Logger LOG = Logger.getLogger(ModifyQueryAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getParameter("delete") != null) {
            return this.delete(mapping, form, request, response);
        }
        if (request.getParameter("export") != null) {
            return this.export(mapping, form, request, response);
        }
        LOG.error((Object)"Don't know what to do");
        throw new RuntimeException("Don't know what to do");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        ModifyQueryForm mqf = (ModifyQueryForm)form;
        String type = request.getParameter("type");
        try {
            profile.disableSaving();
            for (int i = 0; i < mqf.getSelectedQueries().length; ++i) {
                if ("history".equals(type)) {
                    profile.deleteHistory(mqf.getSelectedQueries()[i]);
                    continue;
                }
                profile.deleteQuery(mqf.getSelectedQueries()[i]);
            }
        }
        finally {
            if (profile.getUsername() != null) {
                profile.enableSaving();
            }
        }
        if ("history".equals(type)) {
            return mapping.findForward("history");
        }
        return new ForwardParameters(mapping.findForward("mymine")).addParameter("subtab", "saved").forward();
    }

    public ActionForward export(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Profile profile = SessionMethods.getProfile((HttpSession)session);
        ModifyQueryForm mqf = (ModifyQueryForm)form;
        String type = request.getParameter("type");
        response.setContentType("text/plain; charset=us-ascii");
        response.setHeader("Content-Disposition ", "inline; filename=saved-queries.xml");
        Map map = "history".equals(type) ? profile.getHistory() : profile.getSavedQueries();
        PrintStream out = new PrintStream((OutputStream)response.getOutputStream());
        out.println("<queries>");
        for (int i = 0; i < mqf.getSelectedQueries().length; ++i) {
            String name = mqf.getSelectedQueries()[i];
            PathQuery query = ((SavedQuery)map.get(name)).getPathQuery();
            String modelName = query.getModel().getName();
            String xml = PathQueryBinding.marshal((PathQuery)query, (String)name, (String)modelName, (int)2);
            xml = XmlUtil.indentXmlSimple((String)xml);
            out.println(xml);
        }
        out.println("</queries>");
        return null;
    }
}

