/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.intermine.metadata.ConstraintOp;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OuterJoinStatus;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathConstraintAttribute;
import org.intermine.pathquery.PathConstraintBag;
import org.intermine.pathquery.PathConstraintLookup;
import org.intermine.pathquery.PathConstraintLoop;
import org.intermine.pathquery.PathConstraintMultiValue;
import org.intermine.pathquery.PathConstraintRange;
import org.intermine.pathquery.PathConstraintSubclass;
import org.intermine.pathquery.PathQuery;
import org.intermine.template.SwitchOffAbility;
import org.intermine.template.TemplateQuery;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.QueryBuilderConstraintForm;

public class QueryBuilderConstraintAction
extends InterMineAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ConstraintOp constraintOp;
        boolean constrainToARange;
        HttpSession session = request.getSession();
        if (!this.isTokenValid(request)) {
            return mapping.findForward("query");
        }
        this.resetToken(request);
        PathQuery query = SessionMethods.getQuery((HttpSession)session);
        QueryBuilderConstraintForm constraintForm = (QueryBuilderConstraintForm)form;
        Path path = query.makePath(constraintForm.getPath());
        String rootPath = null;
        rootPath = path.endIsAttribute() ? path.getPrefix().toStringNoConstraints() : path.toStringNoConstraints();
        String joinType = constraintForm.getJoinType();
        String editingConstraintCode = constraintForm.getEditingConstraintCode();
        boolean constrainToAnAttribute = request.getParameter("attribute") != null;
        boolean constrainToABag = request.getParameter("bag") != null;
        boolean constrainToALoop = request.getParameter("loop") != null;
        boolean constrainToASubclass = request.getParameter("subclass") != null;
        boolean constrainToNull = request.getParameter("nullnotnull") != null;
        boolean editingTemplateConstraintParams = request.getParameter("template") != null;
        boolean bl = constrainToARange = request.getParameter("range") != null;
        if (!StringUtils.isEmpty((String)joinType) && rootPath.contains(".")) {
            if ("outer".equals(joinType)) {
                query.setOuterJoinStatus(rootPath, OuterJoinStatus.OUTER);
                List messages = query.fixUpForJoinStyle();
                for (String message : messages) {
                    SessionMethods.recordMessage((String)message, (HttpSession)session);
                }
            } else {
                query.setOuterJoinStatus(rootPath, null);
            }
        }
        PathConstraint oldConstraint = null;
        if (!StringUtils.isBlank((String)editingConstraintCode)) {
            oldConstraint = query.getConstraintForCode(editingConstraintCode);
            if (query instanceof TemplateQuery) {
                TemplateQuery template = (TemplateQuery)query;
                if (editingTemplateConstraintParams) {
                    template.setEditable(oldConstraint, constraintForm.isEditable());
                    template.setConstraintDescription(oldConstraint, constraintForm.getTemplateLabel());
                    String switchable = constraintForm.getSwitchable();
                    if ("on".equals(switchable)) {
                        template.setSwitchOffAbility(oldConstraint, SwitchOffAbility.ON);
                    } else if ("off".equals(switchable)) {
                        template.setSwitchOffAbility(oldConstraint, SwitchOffAbility.OFF);
                    } else {
                        template.setSwitchOffAbility(oldConstraint, SwitchOffAbility.LOCKED);
                    }
                    constraintForm.reset(mapping, request);
                    return mapping.findForward("query");
                }
            }
        }
        PathConstraintSubclass newConstraint = null;
        if (constrainToAnAttribute) {
            constraintOp = ConstraintOp.getOpForIndex((Integer)Integer.valueOf(constraintForm.getAttributeOp()));
            String constraintValue = constraintForm.getAttributeValue();
            if (ConstraintOp.LOOKUP.equals(constraintOp)) {
                newConstraint = new PathConstraintLookup(constraintForm.getPath(), constraintValue, constraintForm.getExtraValue());
            } else if (PathConstraintMultiValue.VALID_OPS.contains(constraintOp)) {
                String multiValues = constraintForm.getMultiValueAttribute();
                newConstraint = new PathConstraintMultiValue(constraintForm.getPath(), constraintOp, Arrays.asList(multiValues.split(",")));
            } else {
                newConstraint = new PathConstraintAttribute(constraintForm.getPath(), constraintOp, constraintValue);
            }
        } else if (constrainToABag) {
            constraintOp = ConstraintOp.getOpForIndex((Integer)Integer.valueOf(constraintForm.getBagOp()));
            String constraintValue = constraintForm.getBagValue();
            Path path1 = query.makePath(constraintForm.getPath());
            if (path1.endIsAttribute()) {
                path1 = path1.getPrefix();
            }
            newConstraint = new PathConstraintBag(path1.getNoConstraintsString(), constraintOp, constraintValue);
        } else if (constrainToALoop) {
            constraintOp = ConstraintOp.getOpForIndex((Integer)Integer.valueOf(constraintForm.getLoopQueryOp()));
            String constraintValue = constraintForm.getLoopQueryValue();
            newConstraint = new PathConstraintLoop(constraintForm.getPath(), constraintOp, constraintValue);
        } else if (constrainToASubclass) {
            newConstraint = new PathConstraintSubclass(constraintForm.getPath(), constraintForm.getSubclassValue());
        } else if (constrainToARange) {
            HashSet<String> ranges = new HashSet<String>();
            String rangeString = constraintForm.getRangeConstraint();
            String[] bits = rangeString.split("[, ]+");
            ranges.addAll(Arrays.asList(bits));
            ConstraintOp constraintOp2 = ConstraintOp.getOpForIndex((Integer)Integer.valueOf(constraintForm.getRangeOp()));
            newConstraint = new PathConstraintRange(constraintForm.getPath(), constraintOp2, ranges);
        } else if (constrainToNull) {
            newConstraint = "NotNULL".equals(constraintForm.getNullConstraint()) ? Constraints.isNotNull((String)constraintForm.getPath()) : Constraints.isNull((String)constraintForm.getPath());
        } else if (constraintForm.getUseJoin() == null) {
            StringBuilder sb = new StringBuilder("attributes = {");
            boolean needComma = false;
            Enumeration attNames = request.getAttributeNames();
            while (attNames.hasMoreElements()) {
                if (needComma) {
                    sb.append(", ");
                }
                needComma = true;
                String attName = (String)attNames.nextElement();
                sb.append(attName).append(" = ").append(request.getAttribute(attName));
            }
            sb.append("}, parameters = {");
            needComma = false;
            for (Map.Entry param : request.getParameterMap().entrySet()) {
                if (needComma) {
                    sb.append(", ");
                }
                needComma = true;
                sb.append((String)param.getKey()).append(" = [");
                boolean needComma2 = false;
                for (String val : (String[])param.getValue()) {
                    if (needComma2) {
                        sb.append(", ");
                    }
                    sb.append(val);
                }
                sb.append("]");
            }
            sb.append("}");
            throw new IllegalArgumentException("Unrecognised action: " + sb);
        }
        if (newConstraint != null) {
            if (oldConstraint != null) {
                if (oldConstraint instanceof PathConstraintSubclass || newConstraint instanceof PathConstraintSubclass) {
                    query.removeConstraint(oldConstraint);
                    query.addConstraint((PathConstraint)newConstraint);
                } else {
                    query.replaceConstraint(oldConstraint, (PathConstraint)newConstraint);
                }
            } else {
                query.addConstraint((PathConstraint)newConstraint);
            }
            if (query instanceof TemplateQuery && !(newConstraint instanceof PathConstraintSubclass) && !(newConstraint instanceof PathConstraintLoop)) {
                ((TemplateQuery)query).setEditable((PathConstraint)newConstraint, true);
            }
        }
        constraintForm.reset(mapping, request);
        return mapping.findForward("query");
    }
}

