/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts;

import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.ProfileManager;
import org.intermine.util.MailUtils;
import org.intermine.web.logic.session.SessionMethods;
import org.intermine.web.struts.InterMineAction;
import org.intermine.web.struts.RequestPasswordForm;
import org.intermine.web.util.URLGenerator;

public class RequestPasswordAction
extends InterMineAction {
    protected static final Logger LOG = Logger.getLogger(RequestPasswordAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InterMineAPI im = SessionMethods.getInterMineAPI((HttpSession)request.getSession());
        ProfileManager pm = im.getProfileManager();
        ServletContext servletContext = request.getSession().getServletContext();
        Properties webProperties = SessionMethods.getWebProperties((ServletContext)servletContext);
        String username = ((RequestPasswordForm)form).getUsername();
        if (pm.hasProfile(username)) {
            try {
                String token = pm.createPasswordChangeToken(username);
                MailUtils.emailPasswordToken((String)username, (String)(new URLGenerator(request).getPermanentBaseURL() + "/passwordReset.do?token=" + token), (Properties)webProperties);
                this.recordMessage(new ActionMessage("login.emailed", (Object)username), request);
            }
            catch (Exception e) {
                LOG.warn((Object)e);
                this.recordError(new ActionMessage("login.mailnotsent", (Object)e), request);
            }
        } else {
            this.recordError(new ActionMessage("login.emptyusername"), request);
        }
        return mapping.findForward("login");
    }
}

