/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts.oauth2;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.oltu.oauth2.common.OAuthProviderType;
import org.intermine.web.struts.oauth2.MessageFormat;
import org.intermine.web.struts.oauth2.OAuthProvider;
import org.intermine.web.struts.oauth2.ResponseType;

public final class DefaultOAuthProvider
implements OAuthProvider {
    private final String clientId;
    private final String clientSecret;
    private final OAuthProviderType provider;

    public DefaultOAuthProvider(Properties properties, OAuthProviderType provider) {
        this.provider = provider;
        String prefix = "oauth2." + provider.name();
        this.clientId = properties.getProperty(prefix + ".client-id");
        this.clientSecret = properties.getProperty(prefix + ".client-secret");
        if (StringUtils.isBlank((String)this.clientId) || StringUtils.isBlank((String)this.clientSecret)) {
            throw new IllegalArgumentException("Bad config: no client config for " + provider);
        }
    }

    public String getTokenUrl() {
        if (OAuthProviderType.GOOGLE == this.provider) {
            return "https://www.googleapis.com/oauth2/v3/token";
        }
        return this.provider.getTokenEndpoint();
    }

    public MessageFormat getMessageFormat() {
        if (OAuthProviderType.MICROSOFT == this.provider || OAuthProviderType.GOOGLE == this.provider) {
            return MessageFormat.BODY;
        }
        return MessageFormat.QUERY;
    }

    public ResponseType getResponseType() {
        if (OAuthProviderType.GITHUB == this.provider || OAuthProviderType.FACEBOOK == this.provider) {
            return ResponseType.FORM;
        }
        return ResponseType.JSON;
    }

    public String getName() {
        return this.provider.name();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }
}

