/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.struts.oauth2;

public final class DelegatedIdentity {
    private final String provider;
    private final String id;
    private final String email;
    private final String name;

    public DelegatedIdentity(String provider, String id, String email, String name) {
        if (provider == null || id == null) {
            throw new NullPointerException("provider and id must have values");
        }
        this.provider = provider;
        this.id = id;
        this.email = email;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getId() {
        return this.id;
    }

    public String getProvider() {
        return this.provider;
    }

    public String toString() {
        return String.format("<%s-identity id=%s email=%s name=%s>", this.provider.toLowerCase(), this.id, this.email, this.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.provider.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DelegatedIdentity other = (DelegatedIdentity)obj;
        if (!this.provider.equals(other.provider)) {
            return false;
        }
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

