/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.web.context.InterMineContext;

public class URLGenerator {
    private HttpServletRequest request;

    public URLGenerator(HttpServletRequest request) {
        this.request = request;
    }

    public String getPermanentBaseURL() {
        String contextPath = this.request.getContextPath();
        return this.generateURL(this.request, contextPath);
    }

    public String getBaseURL() {
        return this.generateURL(this.request, this.request.getContextPath());
    }

    private String generateURL(HttpServletRequest request, String contextPath) {
        Properties webProperties = InterMineContext.getWebProperties();
        String baseUrl = webProperties.getProperty("webapp.baseurl");
        if (StringUtils.isEmpty((String)baseUrl)) {
            return this.getCurrentURL(request, contextPath);
        }
        if (request.getServerPort() != 80 && request.getServerPort() != 443) {
            baseUrl = baseUrl + ":" + request.getServerPort();
        }
        String path = webProperties.getProperty("webapp.path");
        URL url = null;
        try {
            url = new URL(baseUrl + "/" + path);
        }
        catch (MalformedURLException e) {
            return this.getCurrentURL(request, contextPath);
        }
        return url.toString();
    }

    private String getCurrentURL(HttpServletRequest request, String contextPath) {
        String port = "";
        if (request.getServerPort() != 80 && request.getServerPort() != 443) {
            port = ":" + request.getServerPort();
        }
        String ret = request.getScheme() + "://" + request.getServerName() + port;
        if (contextPath.length() > 0) {
            ret = ret + contextPath;
        }
        return ret;
    }
}

