/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.io.IOException;
import java.util.Properties;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.metadata.StringUtil;
import org.intermine.web.context.InterMineContext;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;

public class AvailableServicesServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(AvailableServicesServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String NOT_SUPPORTED_MSG = "This webservice does not support this resource";

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.runService(request, response);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.runService(req, resp);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse resp) {
        this.runService(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runService(HttpServletRequest request, HttpServletResponse response) {
        String pathFromUrl = request.getPathInfo();
        try {
            String resourcePath = this.getResourcePath(pathFromUrl, request);
            response.getWriter().print(resourcePath);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        finally {
            request.getSession().invalidate();
        }
    }

    private String getResourcePath(String resource, HttpServletRequest request) {
        if (resource != null) {
            resource = StringUtil.trimSlashes((String)resource);
            Properties webProperties = InterMineContext.getWebProperties();
            String resourcePath = webProperties.getProperty("resource.path." + resource);
            if (!StringUtils.isEmpty((String)resourcePath)) {
                return resourcePath;
            }
        }
        throw new ResourceNotFoundException(NOT_SUPPORTED_MSG + resource);
    }
}

