/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum Format {
    EMPTY(null),
    DEFAULT("*/*"),
    UNKNOWN(null),
    HTML("text/html"),
    TEXT("text/plain"),
    XML("application/xml"),
    CSV("text/comma-separated-values"),
    TSV("text/tab-separated-values"),
    JSON("application/json"),
    OBJECTS("application/json;format=objects"),
    TABLE("application/json;format=table"),
    ROWS("application/json;format=rows");

    public static final Set<Format> BASIC_FORMATS;
    public static final Set<Format> JSON_FORMATS;
    public static final Set<Format> FLAT_FILES;
    private final String contentType;

    private Format(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String toString() {
        return super.toString() + (this.contentType == null ? "" : " (" + this.contentType + ") ");
    }

    static {
        BASIC_FORMATS = new HashSet<Format>(Arrays.asList(HTML, TEXT, XML, JSON));
        JSON_FORMATS = new HashSet<Format>(Arrays.asList(JSON, OBJECTS, TABLE, ROWS));
        FLAT_FILES = new HashSet<Format>(Arrays.asList(TSV, CSV));
    }
}

