/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.intermine.web.context.InterMineContext;
import org.json.JSONObject;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceListingHandler
extends DefaultHandler {
    private final Map<String, Object> result = new HashMap();
    private final List<Map<String, Object>> auth = new ArrayList();
    private final List<Map<String, Object>> endpoints = new ArrayList();
    private Map<String, Object> currentEndPoint = null;
    private List<Map<String, Object>> methods = null;
    private Map<String, Object> currentMethod = null;
    private List<Map<String, Object>> params = null;
    private Map<String, Object> currentParam = null;
    private List<Map<String, Object>> returns = null;
    private Map<String, Object> format = null;
    private List<Map<String, Object>> bodyFormats = null;
    private String bodyDescription = null;
    private Map<String, Object> currentContentType = null;
    private Stack<String> path = new Stack();
    private StringBuffer sb = null;
    private JSONObject services = null;
    private Properties webProperties = InterMineContext.getWebProperties();
    private static final String DEFAULT_PROP_FMT = "ws.listing.default.%s.%s";
    private static final Pattern WEB_PROPS_INTERPOLATION_PATTERN = Pattern.compile("\\{\\{([\\w\\.]+)\\}\\}");

    @Override
    public void startDocument() {
        this.result.put("auth", this.auth);
        HashMap<String, String> tokenAuth = new HashMap<String, String>();
        tokenAuth.put("name", "API key - parameter");
        tokenAuth.put("type", "token");
        tokenAuth.put("mechanism", "parameter");
        tokenAuth.put("key", "token");
        HashMap<String, String> tokenHeader = new HashMap<String, String>();
        tokenHeader.put("name", "API key - header");
        tokenHeader.put("type", "token");
        tokenHeader.put("mechanism", "header");
        tokenHeader.put("key", "Authorization");
        tokenHeader.put("prefix", "Token ");
        HashMap<String, String> basicAuth = new HashMap<String, String>();
        basicAuth.put("name", "Username and Password");
        basicAuth.put("type", "password");
        basicAuth.put("mechanism", "basic");
        this.auth.add(tokenAuth);
        this.auth.add(tokenHeader);
        this.auth.add(basicAuth);
        this.result.put("endpoints", this.endpoints);
    }

    @Override
    public void endDocument() {
        this.services = new JSONObject(this.result);
    }

    public JSONObject getServices() {
        return this.services;
    }

    private void addToCurrentMethod(String key, Object value) throws SAXException {
        if (this.currentMethod == null) {
            throw new SAXException("Illegal document structure");
        }
        this.currentMethod.put(key, value);
    }

    private String deIndent(String input) {
        if (input == null) {
            return null;
        }
        if (!(input = input.replaceAll("^\\n", "").replaceAll("\\t", "    ")).startsWith(" ")) {
            return input;
        }
        int i = 1;
        while (input.charAt(i) == ' ') {
            ++i;
        }
        String regex = "(?m)^\\s{" + i + "}";
        return input.replaceAll(regex, "");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.path.push(qName);
        if ("servlet-mapping".equals(qName)) {
            this.currentEndPoint = new HashMap();
            this.methods = new ArrayList();
            this.currentEndPoint.put("methods", this.methods);
        } else if ("returns".equals(qName)) {
            this.returns = new ArrayList();
            this.addToCurrentMethod("returnFormats", (Object)this.returns);
        } else if ("description".equals(qName) && "method".equals(this.path.get(Math.max(0, this.path.size() - 2)))) {
            this.currentMethod.put("DescriptionFormat", attrs.getValue("format"));
        } else if ("method".equals(qName)) {
            String also;
            this.currentMethod = new HashMap();
            this.addToCurrentMethod("URI", (Object)String.valueOf(this.currentEndPoint.get("URI")).replaceAll("^/service", ""));
            this.addToCurrentMethod("HTTPMethod", (Object)attrs.getValue("type"));
            this.addToCurrentMethod("RequiresAuthentication", (Object)attrs.getValue("authenticationRequired"));
            String slug = attrs.getValue("slug");
            if (slug != null) {
                this.addToCurrentMethod("URI", (Object)(this.currentMethod.get("URI") + slug));
            }
            if ((also = attrs.getValue("ALSO")) != null) {
                this.addToCurrentMethod("ALSO", (Object)also);
            }
            this.params = new ArrayList();
            this.currentMethod.put("parameters", this.params);
            this.methods.add(this.currentMethod);
        } else if ("body".equals(qName)) {
            this.bodyDescription = attrs.getValue("description");
            this.bodyFormats = new LinkedList();
        } else if ("content".equals(qName)) {
            this.currentContentType = new HashMap();
            this.currentContentType.put("contentType", attrs.getValue("type"));
            this.currentContentType.put("schema", attrs.getValue("schema"));
            this.bodyFormats.add(this.currentContentType);
        } else if ("param".equals(qName)) {
            this.currentParam = new HashMap();
            this.currentParam.put("Required", Boolean.valueOf(attrs.getValue("required")) != false ? "Y" : "N");
            this.currentParam.put("Type", attrs.getValue("type"));
            this.currentParam.put("Description", attrs.getValue("description"));
            this.currentParam.put("Repeat", attrs.getValue("repeat"));
            this.currentParam.put("Depends", attrs.getValue("depends"));
            this.currentParam.put("Schema", attrs.getValue("schema"));
            this.currentParam.put("Options", attrs.getValue("options"));
            this.currentParam.put("Recommended", "true".equals(attrs.getValue("recommended")));
            String defaultValue = attrs.getValue("default");
            defaultValue = this.interpolateDefaultValues(defaultValue);
            if (defaultValue != null) {
                this.currentParam.put("Default", defaultValue);
            }
            if ("enumerated".equals(this.currentParam.get("Type"))) {
                this.currentParam.put("EnumeratedList", Arrays.asList(attrs.getValue("values").split(",")));
            }
            this.params.add(this.currentParam);
        } else if ("format".equals(qName)) {
            this.format = new HashMap();
            int attrLen = attrs.getLength();
            for (int i = 0; i < attrLen; ++i) {
                String ln = attrs.getLocalName(i);
                this.format.put(ln, attrs.getValue(i));
            }
            this.returns.add(this.format);
        }
        this.sb = new StringBuffer();
    }

    private String interpolateDefaultValues(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        Matcher m = WEB_PROPS_INTERPOLATION_PATTERN.matcher(defaultValue);
        StringBuffer interpolated = new StringBuffer();
        while (m.find()) {
            String key = "services.defaults." + m.group(1);
            String value = this.webProperties.getProperty(key, "");
            m.appendReplacement(interpolated, value);
        }
        m.appendTail(interpolated);
        return interpolated.toString();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String[] lines = this.sb.toString().replace("\n", "").trim().split("\n");
        StringBuffer contentBuffer = new StringBuffer();
        for (String line : lines) {
            contentBuffer.append(line.replaceAll("^ +", "") + "\n");
        }
        String content = contentBuffer.toString().trim();
        if ("servlet-mapping".equals(qName)) {
            this.currentEndPoint = null;
        } else if ("url-pattern".equals(qName)) {
            if (this.currentEndPoint != null) {
                this.currentEndPoint.put("URI", StringUtils.chomp((String)content, (String)"/*"));
            }
        } else if ("content".equals(qName)) {
            if (this.currentContentType != null) {
                this.currentContentType.put("example", this.deIndent(this.sb.toString()));
            }
            this.currentContentType = null;
        } else if ("body".equals(qName)) {
            if (this.bodyFormats != null && !this.bodyFormats.isEmpty()) {
                this.currentMethod.put("body", this.bodyFormats);
                this.currentMethod.put("bodyDescription", this.bodyDescription);
            }
            this.bodyFormats = null;
            this.bodyDescription = null;
        } else if ("servlet-name".equals(qName)) {
            if (content.startsWith("ws-") && this.currentEndPoint != null) {
                this.endpoints.add(this.currentEndPoint);
                this.currentEndPoint.put("name", content);
                this.currentEndPoint.put("identifier", content);
            }
        } else if ("name".equals(qName)) {
            if (this.path.contains("method")) {
                this.currentMethod.put("MethodName", content);
            } else if (this.path.contains("metadata")) {
                this.currentEndPoint.put("name", content);
            }
        } else if ("param".equals(qName)) {
            String configuredDefault;
            this.currentParam.put("Name", content);
            if (!this.currentParam.containsKey("Default") && (configuredDefault = this.webProperties.getProperty(String.format(DEFAULT_PROP_FMT, this.currentEndPoint.get("URI"), content))) != null) {
                this.currentParam.put("Default", configuredDefault);
            }
            this.currentParam = null;
        } else if ("format".equals(qName)) {
            this.format.put("Name", content);
            this.format = null;
        } else if ("summary".equals(qName)) {
            this.currentMethod.put("Synopsis", content);
        } else if ("description".equals(qName)) {
            this.currentMethod.put("Description", this.deIndent(this.sb.toString()));
        } else if ("minVersion".equals(qName)) {
            Integer minVersion = Integer.valueOf(content);
            this.currentEndPoint.put("minVersion", minVersion);
        } else if ("returns".equals(qName)) {
            if (this.returns.size() > 1) {
                HashMap<String, Object> formatParam = new HashMap<String, Object>();
                formatParam.put("Name", "format");
                formatParam.put("Required", "N");
                formatParam.put("Default", ((Map)this.returns.get(0)).get("Name"));
                formatParam.put("Type", "enumerated");
                formatParam.put("Description", "Output format");
                ArrayList<String> formatValues = new ArrayList<String>();
                for (Map map : this.returns) {
                    formatValues.add(String.valueOf(map.get("Name")));
                }
                formatParam.put("EnumeratedList", formatValues);
                this.params.add(formatParam);
            }
            this.returns = null;
        } else if ("method".equals(qName)) {
            if (this.currentMethod.containsKey("ALSO")) {
                String[] otherMethods;
                for (String m : otherMethods = String.valueOf(this.currentMethod.get("ALSO")).split(",")) {
                    HashMap<String, String> aliasMethod = new HashMap<String, String>(this.currentMethod);
                    aliasMethod.put("HTTPMethod", m);
                    this.methods.add(aliasMethod);
                }
            }
            this.currentMethod = null;
        }
        this.path.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.sb.append(ch, start, length);
    }
}

