/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.util.AnonProfile;
import org.intermine.util.PropertiesUtil;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.RequestUtil;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.logic.profile.LoginHandler;
import org.intermine.web.security.KeyStorePublicKeySource;
import org.intermine.web.security.PublicKeySource;
import org.intermine.webservice.server.ColumnHeaderStyle;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.JWTVerifier;
import org.intermine.webservice.server.StatusDictionary;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.WebServiceRequestParser;
import org.intermine.webservice.server.core.ListManager;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.MissingParameterException;
import org.intermine.webservice.server.exceptions.NotAcceptableException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.exceptions.UnauthorizedException;
import org.intermine.webservice.server.output.CSVFormatter;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.HTMLTableFormatter;
import org.intermine.webservice.server.output.JSONFormatter;
import org.intermine.webservice.server.output.JSONObjectFormatter;
import org.intermine.webservice.server.output.JSONRowFormatter;
import org.intermine.webservice.server.output.JSONTableFormatter;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.PlainFormatter;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.output.TabFormatter;
import org.intermine.webservice.server.output.XMLFormatter;

public abstract class WebService {
    public static final String DEFAULT_CALLBACK = "callback";
    private static final String COMPRESS = "compress";
    private static final String EXPORT_DATAPACKAGE = "exportDataPackage";
    private static final String GZIP = "gzip";
    private static final String ZIP = "zip";
    private static final Logger LOG = Logger.getLogger(WebService.class);
    private static final String AUTHENTICATION_FIELD_NAME = "Authorization";
    private static final String AUTH_TOKEN_PARAM_KEY = "token";
    private static final Profile ANON_PROFILE = new AnonProfile();
    private static final String WS_HEADERS_PREFIX = "ws.response.header";
    private static final String BOTS = "ws.robots";
    private static final String WEB_SERVICE_DISABLED_PROPERTY = "webservice.disabled";
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected Output output;
    protected Output dataPackageOutput;
    protected OutputStream os;
    protected final InterMineAPI im;
    protected final Properties webProperties = InterMineContext.getWebProperties();
    private ProfileManager.ApiPermission permission = ProfileManager.getDefaultPermission((Profile)ANON_PROFILE);
    private boolean initialised = false;
    private String propertyNameSpace = null;
    protected PrintWriter out = null;
    private String lineBreak = null;
    private Format format = null;
    private Boolean isJsonP = null;

    protected ProfileManager.ApiPermission getPermission() {
        if (this.permission == null) {
            throw new IllegalStateException("There should always be a valid permission object");
        }
        return this.permission;
    }

    protected String getRequiredParameter(String name) {
        String value = this.request.getParameter(name);
        if (StringUtils.isBlank((String)value)) {
            throw new MissingParameterException(name);
        }
        return value;
    }

    protected String getOptionalParameter(String name, String defaultValue) {
        String value = this.request.getParameter(name);
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        return value;
    }

    protected Profile getAuthenticatedUser() {
        Profile profile = this.getPermission().getProfile();
        if (profile.isLoggedIn()) {
            return profile;
        }
        throw new ServiceForbiddenException("You must be logged in to use this service");
    }

    protected ListManager getListManager() {
        return new ListManager(this.im, this.getPermission().getProfile());
    }

    protected String getOptionalParameter(String name) {
        return this.getOptionalParameter(name, null);
    }

    protected Integer getIntParameter(String name) {
        String value = this.getRequiredParameter(name);
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            String msg = String.format("%s should be a valid number. Got %s", name, value);
            throw new BadRequestException(msg, (Throwable)e);
        }
    }

    protected Integer getIntParameter(String name, Integer defaultValue) {
        try {
            return this.getIntParameter(name);
        }
        catch (MissingParameterException e) {
            return defaultValue;
        }
    }

    protected void setNameSpace(String namespace) {
        if (namespace == null || namespace.endsWith(".")) {
            throw new IllegalArgumentException("Namespace must be a non-null string, and may not terminate in a period. Value was: " + namespace);
        }
        if (this.initialised) {
            throw new IllegalStateException("Name space must be set prior to, or as part of, initialisation.");
        }
        this.propertyNameSpace = namespace;
    }

    protected String getProperty(String name) {
        if (StringUtils.contains((String)name, (char)'.')) {
            return this.webProperties.getProperty(name);
        }
        return this.webProperties.getProperty(this.propertyNameSpace == null ? name : this.propertyNameSpace + "." + name);
    }

    public WebService(InterMineAPI im) {
        this.im = im;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) {
        block15: {
            this.request = request;
            this.response = response;
            try {
                if (this.agentIsRobot()) {
                    response.sendError(403);
                } else {
                    this.setHeaders();
                    this.initState();
                    this.initOutput();
                    this.checkEnabled();
                    this.authenticate();
                    this.initialised = true;
                    this.postInit();
                    this.validateState();
                    this.execute();
                }
            }
            catch (Throwable t) {
                this.sendError(t, response);
            }
            if (!this.wantsDataPackage()) {
                try {
                    if (this.output == null) {
                        response.flushBuffer();
                        break block15;
                    }
                    this.output.flush();
                }
                catch (Throwable t) {
                    this.logError(t, "Error flushing", 500);
                }
            } else {
                try {
                    if (this.dataPackageOutput == null) {
                        response.flushBuffer();
                    } else {
                        this.out.flush();
                        this.out.close();
                    }
                }
                catch (Throwable t) {
                    this.logError(t, "Error flushing", 500);
                }
            }
        }
        try {
            this.cleanUp();
        }
        catch (Throwable t) {
            LOG.error((Object)"Error cleaning up", t);
        }
    }

    private boolean agentIsRobot() {
        String ua = this.request.getHeader("User-Agent");
        if (ua != null) {
            String[] robots;
            ua = ua.toLowerCase();
            for (String bot : robots = StringUtils.split((String)this.webProperties.getProperty(BOTS, ""), (char)',')) {
                if (!ua.contains(bot.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private void setHeaders() {
        Properties headerProps = PropertiesUtil.getPropertiesStartingWith((String)WS_HEADERS_PREFIX, (Properties)this.webProperties);
        for (Object o : headerProps.values()) {
            String h = o.toString();
            String[] parts = StringUtils.split((String)h, (String)":", (int)2);
            if (parts.length != 2) {
                LOG.warn((Object)("Ignoring invalid response header: " + h));
                continue;
            }
            this.response.setHeader(parts[0].trim(), parts[1].trim());
        }
        String origin = this.request.getHeader("Origin");
        if (StringUtils.isNotBlank((String)origin)) {
            this.response.setHeader("Access-Control-Allow-Origin", origin);
        }
    }

    private void checkEnabled() {
        if ("true".equalsIgnoreCase(this.webProperties.getProperty(WEB_SERVICE_DISABLED_PROPERTY))) {
            throw new ServiceForbiddenException("Web service is disabled.");
        }
    }

    protected void cleanUp() {
    }

    protected void initState() {
    }

    protected void validateState() {
    }

    protected void postInit() {
    }

    private JWTVerifier.Verification getIdentityFromBearerToken(String rawString) {
        KeyStorePublicKeySource keys;
        try {
            keys = new KeyStorePublicKeySource(InterMineContext.getKeyStore());
        }
        catch (KeyStoreException e) {
            throw new ServiceException("Failed to load key store.", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceException("Key store incorrectly configured", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new ServiceException("Key store incorrectly configured", (Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceException("Failed to load key store.", (Throwable)e);
        }
        try {
            JWTVerifier verifier = new JWTVerifier((PublicKeySource)keys, this.webProperties);
            return verifier.verify(rawString);
        }
        catch (JWTVerifier.VerificationError e) {
            throw new UnauthorizedException(e.getMessage());
        }
    }

    private String getIdentityAssertion() {
        String header = this.webProperties.getProperty("authentication.identity.assertion.header");
        if (StringUtils.isNotBlank((String)header)) {
            return this.request.getHeader(header);
        }
        return null;
    }

    private void authenticate() {
        String authToken = this.request.getParameter(AUTH_TOKEN_PARAM_KEY);
        JWTVerifier.Verification identity = null;
        String authString = this.request.getHeader(AUTHENTICATION_FIELD_NAME);
        ProfileManager pm = this.im.getProfileManager();
        if (StringUtils.isEmpty((String)authToken) && StringUtils.isEmpty((String)authString)) {
            return;
        }
        if (StringUtils.isEmpty((String)authToken)) {
            if (StringUtils.startsWith((String)authString, (String)"Token ")) {
                authToken = StringUtils.removeStart((String)authString, (String)"Token ");
                try {
                    identity = this.getIdentityFromBearerToken(authToken);
                }
                catch (UnauthorizedException unauthorizedException) {}
            } else if (StringUtils.startsWith((String)authString, (String)"Bearer ")) {
                identity = this.getIdentityFromBearerToken(StringUtils.removeStart((String)authString, (String)"Bearer "));
            } else {
                String identityAssertion = this.getIdentityAssertion();
                if (StringUtils.isNotBlank((String)identityAssertion)) {
                    identity = this.getIdentityFromBearerToken(identityAssertion);
                }
            }
        }
        try {
            if (identity != null) {
                this.permission = pm.grantPermission(identity.getIssuer(), identity.getIdentity(), (Map)this.im.getClassKeys());
            } else if (StringUtils.isNotEmpty((String)authToken)) {
                this.permission = pm.getPermission(authToken, (Map)this.im.getClassKeys());
            } else {
                String encoded = StringUtils.removeStart((String)authString, (String)"Basic ");
                String decoded = new String(Base64.decodeBase64((byte[])encoded.getBytes()));
                String[] parts = decoded.split(":", 2);
                if (parts.length != 2) {
                    throw new UnauthorizedException("Invalid request authentication. Authorization field contains invalid value. Decoded authorization value: " + parts[0]);
                }
                if (StringUtils.isEmpty((String)parts[1])) {
                    this.permission = pm.getPermission(parts[0], (Map)this.im.getClassKeys());
                } else {
                    String username = StringUtils.lowerCase((String)parts[0]);
                    String password = parts[1];
                    this.permission = pm.getPermission(username, password, (Map)this.im.getClassKeys());
                }
            }
        }
        catch (ProfileManager.AuthenticationException e) {
            throw new UnauthorizedException(e.getMessage());
        }
        LoginHandler.setUpPermission((InterMineAPI)this.im, (ProfileManager.ApiPermission)this.permission);
    }

    private void sendError(Throwable t, HttpServletResponse response) {
        String msg = "Service failed. Please contact support.";
        boolean showAllMsgs = this.webProperties.containsKey("i.am.a.dev");
        int code = t instanceof ServiceException ? ((ServiceException)t).getHttpErrorCode() : 500;
        String realMsg = t.getMessage();
        if ((showAllMsgs || code < 500) && !StringUtils.isBlank((String)realMsg)) {
            msg = realMsg;
        }
        this.logError(t, realMsg, code);
        if (!this.formatIsJSONP()) {
            response.setStatus(code);
        } else {
            String callback = this.getCallback();
            if (callback == null) {
                callback = "makeInterMineResultsTable";
            }
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put(DEFAULT_CALLBACK, callback);
            this.output.setHeaderAttributes(attributes);
        }
        if (this.output != null) {
            this.output.setError(msg, code);
            LOG.debug((Object)("Set error to : " + msg + "," + code));
        }
    }

    private void logError(Throwable t, String msg, int code) {
        String truncatedStackTrace = this.getTruncatedStackTrace(t);
        if (code == 500) {
            LOG.error((Object)("Service failed by internal error. Request parameters: \n" + this.requestParametersToString() + t + "\n" + truncatedStackTrace));
        } else {
            LOG.debug((Object)("Service didn't succeed. It's not an internal error. Reason: " + this.getErrorDescription(msg, code) + "\n" + truncatedStackTrace));
        }
    }

    private String getTruncatedStackTrace(Throwable t) {
        StackTraceElement[] stack = t.getStackTrace();
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(b);
        boolean tooDeep = false;
        for (int i = 0; !tooDeep && i < stack.length; ++i) {
            StackTraceElement element = stack[i];
            if (element.getClassName().contains("catalina")) {
                tooDeep = true;
                ps.print("\n ...");
                continue;
            }
            ps.print("\n  at ");
            ps.print(element);
        }
        if (t.getCause() != null) {
            ps.print("\n caused by: " + t.getCause() + "\n" + this.getTruncatedStackTrace(t.getCause()));
        }
        ps.flush();
        return b.toString();
    }

    private String requestParametersToString() {
        StringBuilder sb = new StringBuilder();
        Map map = this.request.getParameterMap();
        for (String name : map.keySet()) {
            for (String value : (String[])map.get(name)) {
                sb.append(name);
                sb.append(": ");
                sb.append(value);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private String getErrorDescription(String msg, int errorCode) {
        StringBuilder sb = new StringBuilder();
        sb.append(StatusDictionary.getDescription((int)errorCode));
        sb.append(" ");
        sb.append(msg);
        return sb.toString();
    }

    protected final boolean formatIsJSON() {
        return Format.JSON_FORMATS.contains(this.getFormat());
    }

    protected final boolean formatIsJSONP() {
        if (this.isJsonP == null) {
            this.isJsonP = WebServiceRequestParser.isJsonP((HttpServletRequest)this.request);
        }
        return this.isJsonP;
    }

    protected final boolean formatIsFlatFile() {
        return Format.FLAT_FILES.contains(this.getFormat());
    }

    public boolean formatIsXML() {
        return this.getFormat() == Format.XML;
    }

    protected Output makeXMLOutput(PrintWriter out, String separator) {
        String filename = this.getRequestFileName();
        filename = filename + ".xml";
        ResponseUtil.setXMLHeader((HttpServletResponse)this.response, (String)filename);
        return new StreamedOutput(out, (Formatter)new XMLFormatter(), separator);
    }

    protected Output makeJSONOutput(PrintWriter out, String separator) {
        return new StreamedOutput(out, (Formatter)new JSONFormatter(), separator);
    }

    protected boolean isGzip() {
        return GZIP.equalsIgnoreCase(this.request.getParameter(COMPRESS));
    }

    protected boolean isZip() {
        return ZIP.equalsIgnoreCase(this.request.getParameter(COMPRESS));
    }

    protected boolean isUncompressed() {
        return StringUtils.isEmpty((String)this.request.getParameter(COMPRESS));
    }

    protected boolean wantsDataPackage() {
        return this.request.getParameter(EXPORT_DATAPACKAGE) != null;
    }

    protected String getExtension() {
        if (this.isGzip()) {
            return ".gz";
        }
        if (this.isZip()) {
            return ".zip";
        }
        return "";
    }

    protected PrintWriter getRawOutput() {
        return this.out;
    }

    private void initOutput() {
        String separator = this.getLineBreak();
        try {
            this.response.setBufferSize(8192);
            this.os = this.response.getOutputStream();
            if (this.isGzip()) {
                this.os = new GZIPOutputStream(this.os);
            } else if (this.isZip()) {
                this.os = new ZipOutputStream(new BufferedOutputStream(this.os));
            }
            this.out = new PrintWriter(this.os);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        String filename = this.getRequestFileName();
        switch (1.$SwitchMap$org$intermine$webservice$server$Format[this.getFormat().ordinal()]) {
            case 1: {
                this.output = new StreamedOutput(this.out, (Formatter)new HTMLTableFormatter(), separator);
                ResponseUtil.setHTMLContentType((HttpServletResponse)this.response);
                break;
            }
            case 2: {
                this.output = this.makeXMLOutput(this.out, separator);
                break;
            }
            case 3: {
                this.output = new StreamedOutput(this.out, (Formatter)new TabFormatter(StringUtils.equals((String)this.getProperty("ws.tsv.quoted"), (String)"true")), separator);
                filename = filename + ".tsv";
                if (!this.isUncompressed()) break;
                ResponseUtil.setTabHeader((HttpServletResponse)this.response, (String)filename);
                break;
            }
            case 4: {
                this.output = new StreamedOutput(this.out, (Formatter)new CSVFormatter(), separator);
                filename = filename + ".csv";
                if (!this.isUncompressed()) break;
                ResponseUtil.setCSVHeader((HttpServletResponse)this.response, (String)filename);
                break;
            }
            case 5: {
                this.output = new StreamedOutput(this.out, (Formatter)new PlainFormatter(), separator);
                filename = filename + this.getExtension();
                if (!this.isUncompressed()) break;
                ResponseUtil.setPlainTextHeader((HttpServletResponse)this.response, (String)filename);
                break;
            }
            case 6: {
                this.output = this.makeJSONOutput(this.out, separator);
                filename = filename + ".json";
                if (!this.isUncompressed()) break;
                ResponseUtil.setJSONHeader((HttpServletResponse)this.response, (String)filename, (boolean)this.formatIsJSONP());
                break;
            }
            case 7: {
                this.output = new StreamedOutput(this.out, (Formatter)new JSONObjectFormatter(), separator);
                filename = filename + ".json";
                if (!this.isUncompressed()) break;
                ResponseUtil.setJSONHeader((HttpServletResponse)this.response, (String)filename, (boolean)this.formatIsJSONP());
                break;
            }
            case 8: {
                this.output = new StreamedOutput(this.out, (Formatter)new JSONTableFormatter(), separator);
                filename = "resulttable.json";
                if (!this.isUncompressed()) break;
                ResponseUtil.setJSONHeader((HttpServletResponse)this.response, (String)filename, (boolean)this.formatIsJSONP());
                break;
            }
            case 9: {
                this.output = new StreamedOutput(this.out, (Formatter)new JSONRowFormatter(), separator);
                if (!this.isUncompressed()) break;
                ResponseUtil.setJSONHeader((HttpServletResponse)this.response, (String)"result.json", (boolean)this.formatIsJSONP());
                break;
            }
            default: {
                this.output = this.getDefaultOutput(this.out, this.os, separator);
            }
        }
        if (!this.isUncompressed()) {
            ResponseUtil.setGzippedHeader((HttpServletResponse)this.response, (String)(filename + this.getExtension()));
            if (this.isZip()) {
                try {
                    ((ZipOutputStream)this.os).putNextEntry(new ZipEntry(filename));
                }
                catch (IOException e) {
                    throw new ServiceException((Throwable)e);
                }
            }
        }
    }

    public String getLineBreak() {
        if (this.lineBreak == null && this.request != null) {
            this.lineBreak = RequestUtil.isWindowsClient((HttpServletRequest)this.request) ? "\r\n" : "\n";
        }
        return this.lineBreak;
    }

    protected String getDefaultFileName() {
        return "result";
    }

    protected String getRequestFileName() {
        String param = "filename";
        String fileName = this.request.getParameter(param);
        if (StringUtils.isBlank((String)fileName)) {
            return this.getDefaultFileName();
        }
        return fileName.trim();
    }

    protected Output getDefaultOutput(PrintWriter out, OutputStream os, String separator) {
        this.output = new StreamedOutput(out, (Formatter)new TabFormatter(), separator);
        ResponseUtil.setTabHeader((HttpServletResponse)this.response, (String)this.getDefaultFileName());
        return this.output;
    }

    protected Output getDefaultOutput(PrintWriter out, OutputStream os) {
        return this.getDefaultOutput(out, os, this.getLineBreak());
    }

    public boolean wantsColumnHeaders() {
        String wantsCols = this.request.getParameter("columnheaders");
        boolean no = wantsCols == null || wantsCols.isEmpty() || "0".equals(wantsCols) || "false".equalsIgnoreCase(wantsCols) || "none".equalsIgnoreCase(wantsCols);
        return !no;
    }

    public ColumnHeaderStyle getColumnHeaderStyle() {
        if (this.wantsColumnHeaders()) {
            String style = this.request.getParameter("columnheaders");
            if ("path".equalsIgnoreCase(style)) {
                return ColumnHeaderStyle.PATH;
            }
            return ColumnHeaderStyle.FRIENDLY;
        }
        return ColumnHeaderStyle.NONE;
    }

    protected Format getDefaultFormat() {
        return Format.EMPTY;
    }

    public final Format getFormat() {
        if (this.format == null) {
            List askedFor = WebServiceRequestParser.getAcceptableFormats((HttpServletRequest)this.request);
            if (askedFor.isEmpty()) {
                this.format = this.getDefaultFormat();
            } else {
                for (Format acceptable : askedFor) {
                    if (Format.DEFAULT == acceptable) {
                        this.format = this.getDefaultFormat();
                        break;
                    }
                    if (!this.canServe(acceptable)) continue;
                    this.format = acceptable;
                    break;
                }
                if (this.format == null) {
                    throw new NotAcceptableException();
                }
                if (this.format == Format.EMPTY) {
                    this.format = this.getDefaultFormat();
                }
            }
        }
        return this.format;
    }

    protected void setFormat(Format format) {
        this.format = format;
    }

    public String getCallback() {
        if (this.formatIsJSONP()) {
            return this.getOptionalParameter(DEFAULT_CALLBACK, DEFAULT_CALLBACK);
        }
        return null;
    }

    public boolean hasCallback() {
        return this.getOptionalParameter(DEFAULT_CALLBACK) != null;
    }

    protected abstract void execute() throws Exception;

    public boolean isAuthenticated() {
        return this.getPermission().getProfile() != ANON_PROFILE;
    }

    protected boolean canServe(Format format) {
        return format == this.getDefaultFormat();
    }
}

