/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.core.NoServiceException;
import org.intermine.webservice.server.core.WebServiceServlet;

public class ConfigurableWebServiceServlet
extends WebServiceServlet {
    private static final long serialVersionUID = 1943972842080907136L;
    private Class<? extends WebService> serviceClass = null;
    private Constructor<? extends WebService> constructor = null;
    private final Set<WebServiceServlet.Method> supportedMethods = new HashSet();

    public void init() throws ServletException {
        super.init();
        String className = this.getInitParameter("service");
        if (StringUtils.isBlank((String)className)) {
            throw new ServletException("No service name provided");
        }
        try {
            this.serviceClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("Could not find " + className, (Throwable)e);
        }
        try {
            this.constructor = this.serviceClass.getConstructor(InterMineAPI.class);
        }
        catch (SecurityException e) {
            throw new ServletException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServletException((Throwable)e);
        }
        String methods = this.getInitParameter("methods");
        if (StringUtils.isBlank((String)methods)) {
            throw new ServletException("No methods");
        }
        for (String method : methods.trim().split(",")) {
            WebServiceServlet.Method m = WebServiceServlet.Method.valueOf((String)method.trim());
            this.supportedMethods.add(m);
        }
        if (this.supportedMethods.isEmpty()) {
            throw new ServletException("No supported methods");
        }
    }

    protected WebService getService(WebServiceServlet.Method method) throws NoServiceException {
        if (this.supportedMethods.contains(method)) {
            try {
                return (WebService)this.constructor.newInstance(this.api);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        throw new NoServiceException();
    }
}

