/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.core.Producer;

public class ListManager
implements Producer<Map<String, InterMineBag>> {
    private static final long MAX_WAIT = 0L;
    private final BagManager bagManager;
    private final Profile profile;

    public ListManager(InterMineAPI im, Profile profile) {
        this.bagManager = im.getBagManager();
        this.profile = profile;
    }

    public List<String> getListsNames(Integer objectId) {
        ArrayList<String> ret = new ArrayList<String>();
        Collection bags = this.bagManager.getCurrentBagsContainingId(this.profile, objectId);
        for (InterMineBag bag : bags) {
            ret.add(bag.getName());
        }
        return ret;
    }

    public Collection<InterMineBag> getLists() {
        Date waitUntil = new Date(System.currentTimeMillis() + 0L);
        while (new Date().before(waitUntil) && this.bagManager.isAnyBagNotCurrentOrUpgrading(this.profile)) {
        }
        return this.bagManager.getBags(this.profile).values();
    }

    public Map<String, InterMineBag> getListMap() {
        return Collections.unmodifiableMap(this.bagManager.getBags(this.profile));
    }

    public boolean isAnyBagUnresolvable() {
        return this.bagManager.isAnyBagToUpgrade(this.profile);
    }

    public Collection<InterMineBag> getListsContaining(Integer objectId) {
        return this.bagManager.getCurrentBagsContainingId(this.profile, objectId);
    }

    public Map<String, InterMineBag> produce() {
        return this.getListMap();
    }
}

