/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.idresolution;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagQueryResult;
import org.intermine.api.bag.ConvertedObjectPair;
import org.intermine.api.idresolution.Job;
import org.intermine.api.util.PathUtil;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.Model;
import org.intermine.model.InterMineObject;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.util.DynamicUtil;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.FieldConfigHelper;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.webservice.server.idresolution.BagResultFormatter;

public class BagResultOutputKeyFormatter
implements BagResultFormatter {
    private static final Logger LOG = Logger.getLogger(BagResultOutputKeyFormatter.class);
    private final InterMineAPI im;

    public BagResultOutputKeyFormatter(InterMineAPI api) {
        this.im = api;
    }

    public Map<String, Object> format(Job job) {
        BagQueryResult bqr = job.getResult();
        HashMap<String, Object> ret = new HashMap<String, Object>();
        this.doMatches(ret, bqr);
        this.doDuplicates(ret, bqr, "DUPLICATE");
        this.doDuplicates(ret, bqr, "WILDCARD");
        this.doDuplicates(ret, bqr, "OTHER");
        this.doDuplicates(ret, bqr, "TYPE_CONVERTED");
        return ret;
    }

    private void doDuplicates(Map<String, Object> ret, BagQueryResult bqr, String key) {
        Map issues = (Map)bqr.getIssues().get(key);
        if (issues == null) {
            return;
        }
        for (Map issueSet : issues.values()) {
            for (Map.Entry identToObjects : issueSet.entrySet()) {
                String ident = (String)identToObjects.getKey();
                for (Object o : (List)identToObjects.getValue()) {
                    Map identifiers;
                    Map<String, Map> resultItem;
                    InterMineObject imo;
                    if (o instanceof Integer) {
                        try {
                            imo = this.im.getObjectStore().getObjectById((Integer)o);
                        }
                        catch (ObjectStoreException e) {
                            throw new IllegalStateException("Could not retrieve object reported as match", e);
                        }
                    } else {
                        imo = o instanceof ConvertedObjectPair ? ((ConvertedObjectPair)o).getNewObject() : (InterMineObject)o;
                    }
                    String idKey = String.valueOf(imo.getId());
                    if (ret.containsKey(idKey)) {
                        resultItem = (Map)ret.get(idKey);
                    } else {
                        resultItem = new HashMap();
                        resultItem.put("identifiers", new HashMap());
                    }
                    if (!resultItem.containsKey("summary")) {
                        resultItem.put("summary", this.getObjectDetails(imo));
                    }
                    if (!(identifiers = (Map)resultItem.get("identifiers")).containsKey(ident)) {
                        identifiers.put(ident, new HashSet());
                    }
                    Set categories = (Set)identifiers.get(ident);
                    categories.add(key);
                    String className = DynamicUtil.getSimpleClassName(imo.getClass());
                    resultItem.put("type", (Map)((Object)className.replaceAll("^.*\\.", "")));
                    ret.put(idKey, resultItem);
                }
            }
        }
    }

    private void doMatches(Map<String, Object> ret, BagQueryResult bqr) {
        for (Map.Entry pair : bqr.getMatches().entrySet()) {
            Map<String, Map> resultItem;
            InterMineObject imo;
            try {
                imo = this.im.getObjectStore().getObjectById((Integer)pair.getKey());
            }
            catch (ObjectStoreException e) {
                throw new IllegalStateException("Could not retrieve object reported as match", e);
            }
            String idKey = String.valueOf(imo.getId());
            if (ret.containsKey(idKey)) {
                resultItem = (Map)ret.get(idKey);
            } else {
                resultItem = new HashMap();
                resultItem.put("identifiers", new HashMap());
            }
            if (!resultItem.containsKey("summary")) {
                resultItem.put("summary", this.getObjectDetails(imo));
            }
            Map identifiers = (Map)resultItem.get("identifiers");
            for (Object o : (List)pair.getValue()) {
                String ident = (String)o;
                if (!identifiers.containsKey(ident)) {
                    identifiers.put(ident, new HashSet());
                }
                Set categories = (Set)identifiers.get(ident);
                categories.add("MATCH");
            }
            String className = DynamicUtil.getSimpleClassName(imo.getClass());
            resultItem.put("type", (Map)((Object)className.replaceAll("^.*\\.", "")));
            ret.put(idKey, resultItem);
        }
    }

    private Map<String, Object> getObjectDetails(InterMineObject imo) {
        WebConfig webConfig = InterMineContext.getWebConfig();
        Model m = this.im.getModel();
        HashMap<String, Object> objectDetails = new HashMap<String, Object>();
        String className = DynamicUtil.getSimpleClassName(imo.getClass());
        ClassDescriptor cd = m.getClassDescriptorByName(className);
        for (FieldConfig fc : FieldConfigHelper.getClassFieldConfigs((WebConfig)webConfig, (ClassDescriptor)cd)) {
            try {
                Path p = new Path(m, cd.getUnqualifiedName() + "." + fc.getFieldExpr());
                if (!p.endIsAttribute() || !fc.getShowInSummary()) continue;
                objectDetails.put(p.getNoConstraintsString().replaceAll("^[^.]*\\.", ""), PathUtil.resolvePath((Path)p, (Object)imo));
            }
            catch (PathException e) {
                LOG.error((Object)e);
            }
        }
        return objectDetails;
    }
}

