/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.idresolution;

import org.intermine.api.InterMineAPI;
import org.intermine.api.idresolution.IDResolver;
import org.intermine.api.idresolution.Job;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.NoContentException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.idresolution.BagResultCategoryKeyFormatter;
import org.intermine.webservice.server.idresolution.BagResultOutputKeyFormatter;

public class JobResultsService
extends JSONService {
    private final String jobId;

    public JobResultsService(InterMineAPI im, String jobId) {
        super(im);
        this.jobId = jobId;
    }

    protected void execute() {
        Object formatter = "true".equals(this.getOptionalParameter("idkeys", "false")) ? new BagResultOutputKeyFormatter(this.im) : new BagResultCategoryKeyFormatter(this.im);
        Job job = IDResolver.getInstance().getJobById(this.jobId);
        if (job != null) {
            if (job.getStatus() != Job.JobStatus.SUCCESS) {
                NoContentException se;
                if (job.getStatus() == Job.JobStatus.ERROR) {
                    se = new NoContentException("Job failed: " + job.getError().getMessage());
                    this.addOutputInfo("message", job.getError().getMessage());
                } else {
                    se = new NoContentException("Job not ready");
                }
                throw se;
            }
        } else {
            throw new ResourceNotFoundException("No such job");
        }
        this.addResultItem(formatter.format(job), false);
    }

    protected String getResultsKey() {
        return "results";
    }
}

