/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;

public class ListInput {
    protected final HttpServletRequest request;
    protected final BagManager bagManager;
    private final String listName;
    private final String description;
    private final String type;
    private final String extraValue;
    private final Map<String, InterMineBag> lists = new HashMap();
    private final Map<String, InterMineBag> referencelists = new HashMap();
    private final List<String> tags = new ArrayList();
    protected final Profile profile;
    private final boolean replaceExisting;
    private final Map<String, InterMineBag> toSubtract = new HashMap();
    public static final String SUBTRACT_PARAM = "subtract";
    public static final String NAME_PARAMETER = "name";
    public static final String ALT_NAME_PARAM = "listName";
    public static final String LISTS_PARAMETER = "lists";
    public static final String REFERENCE_PARAMETER = "references";
    public static final String TAGS_PARAMETER = "tags";
    public static final String TYPE_PARAMETER = "type";
    public static final String DESCRIPTION_PARAMETER = "description";
    public static final String REPLACE_PARAMETER = "replaceExisting";
    public static final String TEMP_SUFFIX = "_temp";
    public static final String EXTRA_PARAMETER = "extraValue";
    private static final String DEFAULT_LIST_NAME = "new_list";
    public static final String LIST_SEPARATOR = ";";

    public ListInput(HttpServletRequest request, BagManager bagManager, Profile profile) {
        this.request = request;
        this.bagManager = bagManager;
        this.profile = profile;
        this.listName = this.produceName();
        this.description = request.getParameter(DESCRIPTION_PARAMETER);
        this.replaceExisting = Boolean.parseBoolean(request.getParameter(REPLACE_PARAMETER));
        this.type = request.getParameter(TYPE_PARAMETER);
        this.extraValue = request.getParameter(EXTRA_PARAMETER);
        this.init();
        this.validate();
    }

    protected String produceName() {
        String name;
        String nameParam = this.request.getParameter(NAME_PARAMETER);
        String string = nameParam = StringUtils.isBlank((String)nameParam) ? this.request.getParameter(ALT_NAME_PARAM) : nameParam;
        if (StringUtils.isBlank((String)nameParam)) {
            name = nameParam = DEFAULT_LIST_NAME;
            Set listNames = this.bagManager.getBags(this.profile).keySet();
            int counter = 2;
            while (listNames.contains(name)) {
                name = nameParam + "_" + counter;
                ++counter;
            }
        } else {
            name = nameParam;
        }
        return name;
    }

    public String getListName() {
        return this.listName;
    }

    public String getExtraValue() {
        return this.extraValue;
    }

    public String getTemporaryListName() {
        return this.listName + TEMP_SUFFIX;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public Set<InterMineBag> getLists() {
        return new HashSet<InterMineBag>(this.lists.values());
    }

    public Set<InterMineBag> getReferenceLists() {
        return new HashSet<InterMineBag>(this.referencelists.values());
    }

    public Set<InterMineBag> getSubtractLists() {
        return new HashSet<InterMineBag>(this.toSubtract.values());
    }

    public Set<String> getTags() {
        return new HashSet<String>(this.tags);
    }

    public boolean doReplace() {
        return this.replaceExisting;
    }

    protected void init() {
        this.populateListMap(this.lists, LISTS_PARAMETER);
        this.populateListMap(this.referencelists, REFERENCE_PARAMETER);
        this.populateList(this.tags, TAGS_PARAMETER);
        this.populateListMap(this.toSubtract, SUBTRACT_PARAM);
    }

    protected void populateList(List<String> list, String param) {
        this.populateList(list, param, false);
    }

    protected void populateNormedList(List<String> list, String param) {
        this.populateList(list, param, true);
    }

    private void populateList(List<String> list, String param, boolean lowerCase) {
        String[] paramValues = this.request.getParameterValues(param);
        if (paramValues != null) {
            for (String value : paramValues) {
                String[] subvalues;
                for (String s : subvalues = StringUtils.split((String)value, (String)LIST_SEPARATOR)) {
                    if (lowerCase) {
                        s = s.toLowerCase();
                    }
                    list.add(s);
                }
            }
        }
    }

    protected void populateListMap(Map<String, InterMineBag> map, String param) {
        String[] paramValues = this.request.getParameterValues(param);
        if (paramValues != null) {
            for (String value : paramValues) {
                String[] names;
                for (String name : names = StringUtils.split((String)value, (String)LIST_SEPARATOR)) {
                    InterMineBag list = this.bagManager.getBag(this.profile, name);
                    map.put(name, list);
                }
            }
        }
    }

    private void validate() {
        this.validateRequiredParams();
        this.validateBags();
    }

    protected void validateRequiredParams() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isEmpty((String)this.listName)) {
            errors.add("Required parameter name is missing.");
        }
        if (!errors.isEmpty()) {
            String message = StringUtils.join(errors, (String)", ");
            throw new BadRequestException(message);
        }
    }

    protected void checkLists(Map<String, InterMineBag> map, List<String> errors) {
        for (Map.Entry pair : this.lists.entrySet()) {
            if (pair.getValue() != null) continue;
            errors.add("You do not have access to " + (String)pair.getKey());
        }
    }

    private void validateBags() {
        ArrayList errors = new ArrayList();
        this.checkLists(this.lists, errors);
        this.checkLists(this.referencelists, errors);
        this.checkLists(this.toSubtract, errors);
        if (!errors.isEmpty()) {
            String message = StringUtils.join(errors, (String)", ");
            throw new ServiceForbiddenException(message);
        }
    }
}

