/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.bag.BagManager;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.lists.ListInput;

public class ListRenameInput
extends ListInput {
    private final String oldName;
    private final String newName;
    public static final String OLD_NAME_PARAM = "oldname";
    public static final String NEW_NAME_PARAM = "newname";

    public ListRenameInput(HttpServletRequest request, BagManager bagManager, Profile profile) {
        super(request, bagManager, profile);
        this.oldName = request.getParameter(OLD_NAME_PARAM);
        this.newName = request.getParameter(NEW_NAME_PARAM);
        this.validateRenameParams();
        this.validateBagAccess();
    }

    String getNewName() {
        return this.newName;
    }

    String getOldName() {
        if (!StringUtils.isEmpty((String)this.oldName)) {
            return this.oldName;
        }
        return this.getListName();
    }

    protected String produceName() {
        return this.request.getParameter("name");
    }

    protected void validateRequiredParams() {
    }

    private void validateRenameParams() {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isEmpty((String)this.oldName) && StringUtils.isEmpty((String)this.getListName())) {
            errors.add("Both 'name' and 'oldname' are missing - at least one is required");
        }
        if (!StringUtils.isEmpty((String)this.oldName) && !StringUtils.isEmpty((String)this.getListName())) {
            errors.add("Values have been supplied for 'oldname' (" + this.oldName + ") and '" + "name" + "' (" + this.getListName() + "), but at most one value is expected");
        }
        if (StringUtils.isEmpty((String)this.newName)) {
            errors.add("Required parameter 'newname' is missing");
        }
        if (!errors.isEmpty()) {
            String message = StringUtils.join(errors, (String)", ");
            throw new BadRequestException(message + " - PARAMS: " + this.request.getQueryString());
        }
    }

    private void validateBagAccess() {
        if (!this.profile.getSavedBags().containsKey(this.getOldName())) {
            throw new ServiceForbiddenException("You do not have access to a list called '" + this.getOldName() + "'.");
        }
    }
}

