/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.lists;

import java.io.BufferedReader;
import java.util.ArrayList;
import org.apache.commons.lang.text.StrMatcher;
import org.apache.commons.lang.text.StrTokenizer;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.lists.ListUploadService;

public class ListUpgradingService
extends ListUploadService {
    public ListUpgradingService(InterMineAPI im) {
        super(im);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        Profile profile = this.getPermission().getProfile();
        String listName = this.getRequiredParameter("name");
        ArrayList<Integer> internalIDs = new ArrayList<Integer>();
        InterMineBag listToUpgrade = (InterMineBag)profile.getSavedBags().get(listName);
        if (listToUpgrade == null) {
            throw new ResourceNotFoundException(listName + " doesn't exists");
        }
        if (!listToUpgrade.isToUpgrade()) {
            throw new BadRequestException(listName + " can not be upgraded because its state is " + listToUpgrade.getState());
        }
        BufferedReader r = this.getReader(this.request);
        StrMatcher matcher = this.getMatcher();
        String line = null;
        try {
            while ((line = r.readLine()) != null) {
                StrTokenizer st = new StrTokenizer(line, matcher);
                while (st.hasNext()) {
                    String token = st.nextToken();
                    internalIDs.add(Integer.parseInt(token));
                }
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        listToUpgrade.upgradeOsb(internalIDs, true);
        this.addOutputInfo("listName", listToUpgrade.getName());
        this.addOutputInfo("listSize", "" + listToUpgrade.size());
        this.addOutputInfo("listId", "" + listToUpgrade.getSavedBagId());
    }
}

