/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.oauth2;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.URLConnectionClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.GitHubTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthAuthzResponse;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.client.response.OAuthResourceResponse;
import org.apache.oltu.oauth2.common.OAuthProviderType;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.DuplicateMappingException;
import org.intermine.api.profile.Profile;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.profile.LoginHandler;
import org.intermine.web.logic.profile.ProfileMergeIssues;
import org.intermine.web.struts.oauth2.CustomOAuthProvider;
import org.intermine.web.struts.oauth2.DefaultOAuthProvider;
import org.intermine.web.struts.oauth2.DelegatedIdentity;
import org.intermine.web.struts.oauth2.ForseenProblem;
import org.intermine.web.struts.oauth2.OAuthProvider;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.oauth2.CallbackService;
import org.intermine.webservice.server.user.JSONUserFormatter;
import org.json.JSONException;
import org.json.JSONObject;

public class CallbackService
extends JSONService {
    private static final Logger LOG = Logger.getLogger(CallbackService.class);

    public CallbackService(InterMineAPI im) {
        super(im);
    }

    protected String getResultsKey() {
        return "output";
    }

    protected void execute() throws Exception {
        String providerName = this.getRequiredParameter("provider");
        String redirectUri = this.getRequiredParameter("redirect_uri");
        try {
            OAuthProvider provider = this.getOAuthProvider(this.webProperties, providerName);
            OAuthAuthzResponse oar = this.getAuthResponse(this.request);
            String accessToken = this.getAccessToken(redirectUri, oar, provider);
            DelegatedIdentity identity = this.getDelegatedIdentity(providerName, accessToken);
            Profile profile = this.getProfile(identity);
            HashMap<String, Object> output = new HashMap<String, Object>();
            JSONUserFormatter formatter = new JSONUserFormatter(profile);
            output.put("user", new JSONObject(formatter.format()));
            output.put("token", this.im.getProfileManager().generate24hrKey(profile));
            Profile currentProfile = this.getPermission().getProfile();
            ProfileMergeIssues issues = null;
            if (currentProfile != null && StringUtils.isEmpty((String)currentProfile.getUsername())) {
                issues = LoginHandler.mergeProfiles((Profile)currentProfile, (Profile)profile);
                output.put("renamedLists", new JSONObject(issues.getRenamedBags()));
            } else {
                output.put("renamedLists", new JSONObject(Collections.emptyMap()));
            }
            this.addResultItem(output, false);
        }
        catch (Exception e) {
            LOG.error((Object)"Error granting access", (Throwable)e);
        }
    }

    private OAuthProvider getOAuthProvider(Properties webProperties, String providerName) throws ForseenProblem {
        OAuthProvider provider;
        try {
            provider = this.getProvider(webProperties, providerName);
        }
        catch (IllegalArgumentException e) {
            throw new ForseenProblem("oauth2.error.unknown-provider", new Object[]{providerName});
        }
        return provider;
    }

    private OAuthProvider getProvider(Properties properties, String providerName) {
        if (properties.containsKey("oauth2." + providerName + ".url.token")) {
            return new CustomOAuthProvider(properties, providerName);
        }
        return new DefaultOAuthProvider(properties, OAuthProviderType.valueOf((String)providerName));
    }

    private OAuthAuthzResponse getAuthResponse(HttpServletRequest request) throws ForseenProblem {
        OAuthAuthzResponse oar;
        try {
            oar = OAuthAuthzResponse.oauthCodeAuthzResponse((HttpServletRequest)request);
        }
        catch (OAuthProblemException e) {
            throw new ForseenProblem("oauth2.error.getting-code", new Object[]{e.getMessage()});
        }
        return oar;
    }

    private String getAccessToken(String redirect, OAuthAuthzResponse oar, OAuthProvider provider) throws OAuthSystemException, OAuthProblemException {
        OAuthClientRequest clientReq;
        OAuthClient oauthClient = new OAuthClient((HttpClient)new URLConnectionClient());
        OAuthClientRequest.TokenRequestBuilder requestBuilder = OAuthClientRequest.tokenLocation((String)provider.getTokenUrl()).setGrantType(GrantType.AUTHORIZATION_CODE).setClientId(provider.getClientId()).setClientSecret(provider.getClientSecret()).setRedirectURI(redirect).setCode(oar.getCode());
        switch (1.$SwitchMap$org$intermine$web$struts$oauth2$MessageFormat[provider.getMessageFormat().ordinal()]) {
            case 1: {
                clientReq = requestBuilder.buildBodyMessage();
                break;
            }
            case 2: {
                clientReq = requestBuilder.buildQueryMessage();
                break;
            }
            default: {
                throw new RuntimeException("Unknown message format");
            }
        }
        LOG.info((Object)("Requesting access token: URI = " + clientReq.getLocationUri() + " BODY = " + clientReq.getBody()));
        try {
            OAuthJSONAccessTokenResponse tokenResponse = null;
            switch (1.$SwitchMap$org$intermine$web$struts$oauth2$ResponseType[provider.getResponseType().ordinal()]) {
                case 1: {
                    tokenResponse = oauthClient.accessToken(clientReq, GitHubTokenResponse.class);
                    break;
                }
                case 2: {
                    tokenResponse = oauthClient.accessToken(clientReq);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown response type");
                }
            }
            return tokenResponse.getAccessToken();
        }
        catch (OAuthProblemException ex) {
            throw new BadRequestException(ex.getMessage());
        }
    }

    private DelegatedIdentity getDelegatedIdentity(String providerName, String accessToken) throws OAuthSystemException, OAuthProblemException, JSONException {
        if (this.providerIsSane(providerName)) {
            return this.getSaneProviderUserInfo(providerName, accessToken);
        }
        throw new RuntimeException("Missing config: oauth2." + providerName + ".identity-resource");
    }

    private boolean providerIsSane(String providerName) {
        Properties webProperties = InterMineContext.getWebProperties();
        return webProperties.containsKey("oauth2." + providerName + ".identity-resource");
    }

    private DelegatedIdentity getSaneProviderUserInfo(String provider, String accessToken) throws OAuthSystemException, OAuthProblemException, JSONException {
        OAuthClientRequest bearerClientRequest;
        Properties props = InterMineContext.getWebProperties();
        String prefix = "oauth2." + provider;
        String identityEndpoint = props.getProperty(prefix + ".identity-resource");
        String envelopeKey = props.getProperty(prefix + ".identity-envelope");
        String idKey = props.getProperty(prefix + ".id-key", "id");
        String nameKey = props.getProperty(prefix + ".name-key", "name");
        String emailKey = props.getProperty(prefix + ".email-key", "email");
        String authMechanism = props.getProperty(prefix + ".resource-auth-mechanism", "queryparam");
        OAuthBearerClientRequest requestBuilder = new OAuthBearerClientRequest(identityEndpoint).setAccessToken(accessToken);
        if ("queryparam".equals(authMechanism)) {
            bearerClientRequest = requestBuilder.buildQueryMessage();
        } else if ("header".equals(authMechanism)) {
            bearerClientRequest = requestBuilder.buildHeaderMessage();
        } else if ("body".equals(authMechanism)) {
            bearerClientRequest = requestBuilder.buildBodyMessage();
        } else {
            throw new OAuthSystemException("Unknown authorisation mechanism: " + authMechanism);
        }
        LOG.debug((Object)("Requesting identity information: URI = " + bearerClientRequest.getLocationUri() + " HEADERS = " + bearerClientRequest.getHeaders() + " BODY = " + bearerClientRequest.getBody()));
        bearerClientRequest.setHeader("Accept", "application/json");
        OAuthClient oauthClient = new OAuthClient((HttpClient)new URLConnectionClient());
        OAuthResourceResponse resp = (OAuthResourceResponse)oauthClient.resource(bearerClientRequest, "GET", OAuthResourceResponse.class);
        return this.parseIdentity(provider, envelopeKey, idKey, nameKey, emailKey, resp.getBody());
    }

    private DelegatedIdentity parseIdentity(String provider, String envelopeKey, String idKey, String nameKey, String emailKey, String body) throws JSONException {
        String email;
        JSONObject result = new JSONObject(body);
        if (StringUtils.isNotBlank((String)envelopeKey)) {
            result = result.getJSONObject(envelopeKey);
        }
        String id = result.get(idKey).toString();
        String[] nameKeyParts = nameKey.split(",");
        Object[] nameParts = new String[nameKeyParts.length];
        for (int i = 0; i < nameKeyParts.length; ++i) {
            nameParts[i] = result.getString(nameKeyParts[i]);
        }
        String name = StringUtils.join((Object[])nameParts, (String)" ");
        JSONObject emails = result.optJSONObject("emails");
        if (emails == null) {
            email = result.optString(emailKey);
        } else {
            email = emails.optString("preferred");
            if (email == null) {
                email = emails.optString("account");
            }
        }
        return new DelegatedIdentity(provider, id, email, name);
    }

    private Profile getProfile(DelegatedIdentity identity) {
        Profile profile = this.im.getProfileManager().grantPermission(identity.getProvider(), identity.getId(), (Map)this.im.getClassKeys()).getProfile();
        Map preferences = profile.getPreferences();
        if (!preferences.containsKey("email")) {
            preferences.put("email", identity.getEmail());
        }
        preferences.put("email", identity.getEmail());
        String identityName = identity.getName();
        if (!"".equals(identityName)) {
            String aka = "";
            if (preferences.containsKey("aka")) {
                aka = (String)preferences.get("aka");
            }
            if ("".equals(aka)) {
                preferences.put("aka", identityName);
            }
            String alias = "";
            if (preferences.containsKey("alias")) {
                alias = (String)preferences.get("alias");
            }
            if ("".equals(alias)) {
                int c = 0;
                alias = identityName;
                do {
                    try {
                        preferences.put("alias", alias);
                    }
                    catch (DuplicateMappingException e) {
                        alias = identityName + " " + ++c;
                    }
                } while (!preferences.containsKey("alias"));
            }
        }
        return profile;
    }
}

