/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.output;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringEscapeUtils;
import org.intermine.webservice.server.StatusDictionary;
import org.intermine.webservice.server.output.Formatter;

public class XMLFormatter
extends Formatter {
    private final Stack<String> openElements = new Stack();

    protected void pushTag(String tag) {
        this.openElements.push(tag);
    }

    protected String popTag() {
        return (String)this.openElements.pop();
    }

    protected String getRootElement() {
        return "ResultSet";
    }

    protected String getRowElement() {
        return "Result";
    }

    protected String getItemElement() {
        return "i";
    }

    protected String getErrorElement() {
        return "error";
    }

    protected String getMessageElement() {
        return "message";
    }

    protected String getCauseElement() {
        return "cause";
    }

    protected String getProcessingInstruction() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    }

    public String formatHeader(Map<String, Object> attributes) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProcessingInstruction());
        String elem = this.getRootElement();
        this.openElements.push(elem);
        sb.append("\n<" + elem + " ");
        this.handleHeaderAttributes(attributes, sb);
        return sb.toString();
    }

    protected void handleHeaderAttributes(Map<String, Object> attributes, StringBuilder sb) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                if (attributes.get(key) instanceof Map) {
                    Map obj = (Map)attributes.get(key);
                    for (Object subK : obj.keySet()) {
                        sb.append(subK + "=\"" + this.escapeAttribute(obj.get(subK)) + "\" ");
                    }
                    continue;
                }
                sb.append(key + "=\"" + this.escapeAttribute(attributes.get(key)) + "\" ");
            }
        }
        sb.append(">");
    }

    protected String escapeAttribute(Object attr) {
        return StringEscapeUtils.escapeXml((String)String.valueOf(attr));
    }

    public String formatResult(List<String> resultRow) {
        StringBuilder sb = new StringBuilder();
        String elem = this.getRowElement();
        sb.append("<" + elem + ">");
        this.openElements.push(elem);
        for (String s : resultRow) {
            this.addElement(sb, this.getItemElement(), s);
        }
        sb.append("</" + elem + ">");
        this.openElements.pop();
        return sb.toString();
    }

    protected void addElement(StringBuilder sb, String tag, String contents) {
        sb.append("<" + tag + ">");
        this.openElements.push(tag);
        sb.append(this.escapeElementContent(contents));
        sb.append("</" + (String)this.openElements.pop() + ">");
    }

    protected String escapeElementContent(String contents) {
        return StringEscapeUtils.escapeXml((String)contents);
    }

    public String formatFooter(String errorMessage, int errorCode) {
        StringBuilder sb = new StringBuilder();
        if (this.openElements.isEmpty()) {
            sb.append("<" + this.getRootElement() + ">");
        }
        while (!this.openElements.isEmpty()) {
            String openTag = (String)this.openElements.pop();
            if (this.getRootElement().equals(openTag)) continue;
            sb.append("</" + openTag + ">");
        }
        if (errorCode != 200) {
            sb.append("<" + this.getErrorElement() + ">");
            this.addElement(sb, this.getMessageElement(), StatusDictionary.getDescription((int)errorCode));
            this.addElement(sb, this.getCauseElement(), errorMessage);
            sb.append("</" + this.getErrorElement() + ">");
        }
        sb.append("</" + this.getRootElement() + ">");
        return sb.toString();
    }
}

