/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.path;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QueryFunction;
import org.intermine.objectstore.query.QueryNode;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebServiceRequestParser;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.path.PossibleValuesService;
import org.json.JSONException;
import org.json.JSONObject;

public class PossibleValuesService
extends JSONService {
    private static final String TYPE_CONSTRAINTS_SHOULD_BE_JSON = "The value of 'typeConstraints' should be a json string";
    private static final String TYPE_CONSTRAINTS_ARE_STRINGS = "The typeConstraints object may only have strings as values";
    private static final int DEFAULT_BATCH_SIZE = 5000;
    private boolean count = false;
    private Path path;

    public PossibleValuesService(InterMineAPI im) {
        super(im);
    }

    protected Format getDefaultFormat() {
        return Format.OBJECTS;
    }

    protected boolean canServe(Format format) {
        switch (1.$SwitchMap$org$intermine$webservice$server$Format[format.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    protected void initState() {
        super.initState();
        this.count = WebServiceRequestParser.isCountRequest((HttpServletRequest)this.request);
    }

    protected Map<String, Object> getHeaderAttributes() {
        Map attrs = super.getHeaderAttributes();
        if (this.count) {
            attrs.put("intro", "\"count\":");
        } else {
            attrs.put("intro", "\"results\":[");
            attrs.put("outro", "]");
        }
        return attrs;
    }

    protected void postInit() {
        JSONObject typeJO;
        super.postInit();
        String pathString = this.getRequiredParameter("path").trim();
        this.addOutputInfo("path", pathString);
        String typeConstraintStr = this.getOptionalParameter("typeConstraints", "{}");
        HashMap<String, String> typeMap = new HashMap<String, String>();
        try {
            typeJO = new JSONObject(typeConstraintStr);
        }
        catch (JSONException e) {
            throw new BadRequestException(TYPE_CONSTRAINTS_SHOULD_BE_JSON);
        }
        Iterator it = typeJO.keys();
        while (it.hasNext()) {
            String subType;
            String name = (String)it.next();
            try {
                subType = typeJO.getString(name);
            }
            catch (JSONException e) {
                throw new BadRequestException(TYPE_CONSTRAINTS_ARE_STRINGS);
            }
            typeMap.put(name, subType);
        }
        try {
            this.path = typeMap.isEmpty() ? new Path(this.model, pathString) : new Path(this.model, pathString, typeMap);
        }
        catch (PathException e) {
            throw new BadRequestException("Bad path given: " + pathString, (Throwable)e);
        }
    }

    protected void execute() throws Exception {
        Query q = new Query();
        this.addOutputInfo("class", this.path.getLastClassDescriptor().getUnqualifiedName());
        this.addOutputInfo("field", this.path.getLastElement());
        String type = ((AttributeDescriptor)this.path.getEndFieldDescriptor()).getType();
        String[] parts = StringUtils.split((String)type, (char)'.');
        this.addOutputInfo("type", parts[parts.length - 1]);
        QueryClass qc = new QueryClass(new Class[]{this.path.getPrefix().getEndType()});
        q.addFrom((FromElement)qc);
        QueryField qf1 = new QueryField(qc, this.path.getLastElement());
        q.addToSelect((QuerySelectable)qf1);
        QueryFunction qf = new QueryFunction();
        q.addToSelect((QuerySelectable)qf);
        q.addToGroupBy((QueryNode)qf1);
        int total = this.im.getObjectStore().count(q, ObjectStore.SEQUENCE_IGNORE);
        if (this.count) {
            this.addResultValue((Number)total, false);
        } else {
            this.addOutputInfo("count", Integer.toString(total));
            Results results = this.im.getObjectStore().execute(q, 5000, true, true, false);
            Iterator iter = results.iterator();
            while (iter.hasNext()) {
                List row = (List)iter.next();
                HashMap jsonMap = new HashMap();
                jsonMap.put("value", row.get(0));
                jsonMap.put("count", row.get(1));
                this.addResultItem(jsonMap, iter.hasNext());
            }
        }
    }
}

