/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query;

import java.util.Arrays;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.Query;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.lists.ListInput;
import org.intermine.webservice.server.query.QueryToListService;

public class QueryListAppendService
extends QueryToListService {
    public QueryListAppendService(InterMineAPI api) {
        super(api);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateListFromQuery(PathQuery pq, ListInput input, Profile profile) throws ObjectStoreException, PathException {
        String name = input.getListName();
        InterMineBag list = this.getList(profile, name);
        this.checkQueryMatchesListType(pq, list);
        Query q = this.getQuery(pq, profile);
        try {
            list.addToBagFromQuery(q);
        }
        catch (Throwable throwable) {
            this.setHeaderAttributes(name, list.getSavedBagId());
            this.output.addResultItem(Arrays.asList("" + list.size()));
            throw throwable;
        }
        this.setHeaderAttributes(name, list.getSavedBagId());
        this.output.addResultItem(Arrays.asList("" + list.size()));
    }

    protected InterMineBag getList(Profile profile, String name) {
        InterMineBag list = (InterMineBag)profile.getSavedBags().get(name);
        if (list == null) {
            throw new ServiceForbiddenException(name + " is not a list you have access to");
        }
        return list;
    }

    private void checkQueryMatchesListType(PathQuery pq, InterMineBag list) {
        Path path;
        String view = (String)pq.getView().get(0);
        try {
            path = pq.makePath(view);
        }
        catch (PathException e) {
            throw new ServiceException((Throwable)e);
        }
        ClassDescriptor queryClass = path.getLastClassDescriptor();
        String type = list.getQualifiedType();
        if (!queryClass.getAllSuperclassNames().contains(type)) {
            throw new BadRequestException("This query is not compatible with '" + list.getName() + "' as the type of its result set (" + queryClass.getUnqualifiedName() + ") is not a " + list.getType());
        }
    }
}

