/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.SavedQuery;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.core.Predicate;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.PlainFormatter;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.query.SavedQueryRetrievalService;
import org.json.JSONException;
import org.json.JSONObject;

public class SavedQueryRetrievalService
extends JSONService {
    public SavedQueryRetrievalService(InterMineAPI im) {
        super(im);
    }

    protected boolean canServe(Format format) {
        switch (1.$SwitchMap$org$intermine$webservice$server$Format[format.ordinal()]) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader((HttpServletResponse)this.response, (String)"saved-queries.xml");
        return new StreamedOutput(out, (Formatter)new PlainFormatter(), separator);
    }

    protected void execute() {
        Profile p = this.getPermission().getProfile();
        Predicate filter = this.getFilter(this.getOptionalParameter("filter", ""));
        Map queries = this.getQueries(filter, p.getSavedQueries());
        if (Format.JSON == this.getFormat()) {
            this.sendJSON(queries);
        } else {
            this.sendXML(queries);
        }
    }

    private void sendXML(Map<String, SavedQuery> queries) {
        int version = this.im.getProfileManager().getVersion();
        try {
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(this.getRawOutput());
            writer.writeStartElement("saved-queries");
            for (Map.Entry<String, SavedQuery> pair : queries.entrySet()) {
                PathQuery pq = pair.getValue().getPathQuery();
                PathQueryBinding.marshal((PathQuery)pq, (String)pair.getKey(), (String)pq.getModel().getName(), (XMLStreamWriter)writer, (int)version);
            }
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new ServiceException("Serialization error.", (Throwable)e);
        }
    }

    private void sendJSON(Map<String, SavedQuery> queries) {
        JSONObject result = new JSONObject();
        try {
            for (Map.Entry<String, SavedQuery> pair : queries.entrySet()) {
                SavedQuery sq = pair.getValue();
                Date dateCreated = sq.getDateCreated();
                result.put(pair.getKey(), (Object)new JSONObject(sq.getPathQuery().toJson(dateCreated)));
            }
            this.output.addResultItem(Arrays.asList(result.toString(0)));
        }
        catch (JSONException e) {
            throw new ServiceException("Serialization error.", (Throwable)e);
        }
    }

    private Map<String, SavedQuery> getQueries(Predicate<String> filter, Map<String, SavedQuery> allSaved) {
        HashMap<String, SavedQuery> queries = new HashMap<String, SavedQuery>();
        for (Map.Entry<String, SavedQuery> pair : allSaved.entrySet()) {
            SavedQuery q = pair.getValue();
            if (!filter.call((Object)pair.getKey()).booleanValue()) continue;
            queries.put(pair.getKey(), q);
        }
        return queries;
    }

    private Predicate<String> getFilter(String filter) {
        if (StringUtils.isBlank((String)(filter = filter.trim())) || "*".equals(filter)) {
            return new AlwaysTrue(this, null);
        }
        String noStars = filter.replaceAll("(^\\*|\\*$)", "");
        if (StringUtils.isBlank((String)noStars)) {
            throw new BadRequestException("Illegal filter string");
        }
        if (filter.startsWith("*")) {
            if (filter.endsWith("*")) {
                return new Contains(this, noStars);
            }
            return new EndsWith(this, noStars);
        }
        if (filter.endsWith("*")) {
            return new StartsWith(this, noStars);
        }
        return new Matches(this, noStars);
    }

    public String getResultsKey() {
        return "queries";
    }
}

