/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.query.result;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagQueryRunner;
import org.intermine.api.profile.Profile;
import org.intermine.api.query.BagNotFound;
import org.intermine.api.query.MainHelper;
import org.intermine.api.query.PathQueryExecutor;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.Results;
import org.intermine.pathquery.PathQuery;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.Either;
import org.intermine.webservice.server.core.EitherVisitor;
import org.intermine.webservice.server.core.Page;
import org.intermine.webservice.server.core.TableRowIterator;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.query.result.QueryResultService;
import org.intermine.webservice.server.query.result.TableRowService;
import org.json.JSONArray;

public class TableRowService
extends QueryResultService {
    public TableRowService(InterMineAPI im) {
        super(im);
    }

    protected Format getDefaultFormat() {
        return Format.JSON;
    }

    protected boolean canServe(Format format) {
        return format == Format.JSON;
    }

    protected void setHeaderAttributes(PathQuery pq, Integer start, Integer size) {
        try {
            Profile p = this.getPermission().getProfile();
            PathQueryExecutor pqe = this.im.getPathQueryExecutor(p);
            int count = pqe.count(pq);
            this.attributes.put("iTotalRecords", count);
        }
        catch (BagNotFound e) {
            throw new BadRequestException(e.getMessage());
        }
        catch (ObjectStoreException e) {
            throw new ServiceException("Error counting rows.", (Throwable)e);
        }
        super.setHeaderAttributes(pq, start, size);
    }

    public void runPathQuery(PathQuery pathQuery, int firstResult, int maxResults) {
        Query q;
        ObjectStore os = this.im.getObjectStore();
        Profile p = this.getPermission().getProfile();
        HashMap pathToQueryNode = new HashMap();
        try {
            q = MainHelper.makeQuery((PathQuery)pathQuery, (Map)this.im.getBagManager().getCurrentBags(p), pathToQueryNode, (BagQueryRunner)this.im.getBagQueryRunner(), new HashMap());
        }
        catch (ObjectStoreException e) {
            throw new ServiceException("Could not run query", (Throwable)e);
        }
        Results results = os.execute(q, 5000, true, false, false);
        Page page = new Page(firstResult, maxResults == 0 ? null : Integer.valueOf(maxResults));
        Query realQ = results.getQuery();
        if (realQ == q) {
            this.getPathQueryExecutor().updateQueryToPathToQueryNode(q, pathToQueryNode);
        }
        TableRowIterator iter = new TableRowIterator(pathQuery, q, results, pathToQueryNode, page, this.im);
        Processor processor = new Processor(this.im);
        while (iter.hasNext()) {
            LinkedList<Map> rowdata = new LinkedList<Map>();
            for (Either cell : iter.next()) {
                rowdata.add((Map)cell.accept((EitherVisitor)processor));
            }
            JSONArray ja = new JSONArray(rowdata);
            if (iter.hasNext()) {
                this.output.addResultItem(Arrays.asList(ja.toString(), ""));
                continue;
            }
            this.output.addResultItem(Arrays.asList(ja.toString()));
        }
    }
}

