/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.TemplateHelper;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.exceptions.NotAcceptableException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.exceptions.UnauthorizedException;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.PlainFormatter;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.template.AllAvailableTemplatesService;

public class AllAvailableTemplatesService
extends WebService {
    private static final String FILE_BASE_NAME = "templates";

    public AllAvailableTemplatesService(InterMineAPI im) {
        super(im);
    }

    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader((HttpServletResponse)this.response, (String)"templates.xml");
        return new StreamedOutput(out, (Formatter)new PlainFormatter(), separator);
    }

    protected Format getDefaultFormat() {
        return Format.XML;
    }

    protected boolean canServe(Format format) {
        return Format.BASIC_FORMATS.contains(format);
    }

    protected void execute() throws Exception {
        if (this.isAuthenticated()) {
            Profile authenticatedProfile = this.getPermission().getProfile();
            if (!authenticatedProfile.isSuperuser()) {
                throw new UnauthorizedException("The request must be authenticated by a super user");
            }
            switch (1.$SwitchMap$org$intermine$webservice$server$Format[this.getFormat().ordinal()]) {
                case 1: {
                    this.output.addResultItem(Arrays.asList(TemplateHelper.allTemplatesMapToXml((InterMineAPI)this.im)));
                    break;
                }
                case 2: {
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    attributes.put("intro", "\"templates\":");
                    this.output.setHeaderAttributes(attributes);
                    this.output.addResultItem(Arrays.asList(TemplateHelper.allTemplatesMapToJson((InterMineAPI)this.im)));
                    break;
                }
                case 3: {
                    throw new ServiceException("Not implemented: " + Format.TEXT);
                }
                case 4: {
                    throw new ServiceException("Not implemented: " + Format.HTML);
                }
                default: {
                    throw new NotAcceptableException();
                }
            }
        } else {
            throw new UnauthorizedException("The request must be authenticated by a super user");
        }
    }
}

