/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.http.HttpServletResponse;
import org.intermine.api.InterMineAPI;
import org.intermine.api.template.TemplateHelper;
import org.intermine.api.template.TemplateManager;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.WebService;
import org.intermine.webservice.server.exceptions.NotAcceptableException;
import org.intermine.webservice.server.exceptions.ServiceException;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.PlainFormatter;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.template.SystemTemplatesService;

public class SystemTemplatesService
extends WebService {
    private static final String FILE_BASE_NAME = "templates";

    public SystemTemplatesService(InterMineAPI im) {
        super(im);
    }

    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader((HttpServletResponse)this.response, (String)"templates.xml");
        return new StreamedOutput(out, (Formatter)new PlainFormatter(), separator);
    }

    protected Format getDefaultFormat() {
        return Format.XML;
    }

    protected boolean canServe(Format format) {
        return Format.BASIC_FORMATS.contains(format);
    }

    protected void execute() throws Exception {
        TemplateManager templateManager = this.im.getTemplateManager();
        Map templates = templateManager.getSystemTemplates();
        switch (1.$SwitchMap$org$intermine$webservice$server$Format[this.getFormat().ordinal()]) {
            case 1: {
                this.output.addResultItem(Arrays.asList(TemplateHelper.apiTemplateMapToXml((Map)templates, (int)2)));
                break;
            }
            case 2: {
                HashMap<String, String> attributes = new HashMap<String, String>();
                if (this.formatIsJSONP()) {
                    attributes.put("callback", this.getCallback());
                }
                attributes.put("intro", "\"templates\":");
                this.output.setHeaderAttributes(attributes);
                this.output.addResultItem(Arrays.asList(TemplateHelper.apiTemplateMapToJson((InterMineAPI)this.im, (Map)templates, null)));
                break;
            }
            case 3: {
                TreeSet templateNames = new TreeSet(templates.keySet());
                for (String templateName : templateNames) {
                    this.output.addResultItem(Arrays.asList(templateName));
                }
            }
            case 4: {
                throw new ServiceException("Not implemented: " + Format.HTML);
            }
            default: {
                throw new NotAcceptableException();
            }
        }
    }
}

