/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateSummariser;
import org.intermine.webservice.server.Format;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.template.TemplateSummariseStatusService;

public class TemplateSummariseStatusService
extends JSONService {
    public TemplateSummariseStatusService(InterMineAPI im) {
        super(im);
    }

    protected void validateState() {
        if (!this.isAuthenticated() || !this.getPermission().getProfile().isSuperuser()) {
            throw new ServiceForbiddenException("This request is not authenticated.");
        }
    }

    protected boolean canServe(Format format) {
        switch (1.$SwitchMap$org$intermine$webservice$server$Format[format.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    protected void execute() throws Exception {
        String templateName = this.getOptionalParameter("name");
        Profile currentProfile = this.getPermission().getProfile();
        Map templates = currentProfile.getSavedTemplates();
        TemplateSummariser summariser = this.im.getTemplateSummariser();
        HashMap<String, Boolean> summarisedTemplateMap = new HashMap<String, Boolean>();
        if (!StringUtils.isEmpty((String)templateName)) {
            ApiTemplate template = (ApiTemplate)templates.get(templateName);
            if (template == null) {
                throw new BadRequestException("The template " + templateName + " doesn't exist");
            }
            if (template.isValid()) {
                summarisedTemplateMap.put(template.getName(), summariser.isSummarised(template));
            }
        } else {
            for (ApiTemplate template : templates.values()) {
                if (!template.isValid()) continue;
                summarisedTemplateMap.put(template.getName(), summariser.isSummarised(template));
            }
        }
        this.addResultItem(summarisedTemplateMap, false);
    }

    public String getResultsKey() {
        return "templates";
    }
}

