/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.template;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.TransformerUtils;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.TagManager;
import org.intermine.api.profile.Taggable;
import org.intermine.api.search.WebSearchable;
import org.intermine.api.template.ApiTemplate;
import org.intermine.webservice.server.exceptions.BadRequestException;
import org.intermine.webservice.server.exceptions.ResourceNotFoundException;
import org.intermine.webservice.server.exceptions.ServiceForbiddenException;
import org.intermine.webservice.server.template.TemplateTagService;

public class TemplateTagAddingService
extends TemplateTagService {
    private static final String TAGS = "tags";

    public TemplateTagAddingService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        String templateName = this.getRequiredParameter("name");
        Set tags = this.getTags();
        Profile profile = this.getPermission().getProfile();
        Map templates = this.im.getTemplateManager().getUserAndGlobalTemplates(profile);
        ApiTemplate template = (ApiTemplate)templates.get(templateName);
        if (template == null) {
            throw new ResourceNotFoundException("You do not have access to a template called '" + templateName + "'");
        }
        this.modifyTemplate(tags, template);
        List allTags = this.im.getTagManager().getObjectTags((Taggable)template, profile);
        List tagNames = (List)CollectionUtils.collect((Collection)allTags, (Transformer)TransformerUtils.invokerTransformer((String)"getTagName"));
        this.output.addResultItem(tagNames);
    }

    protected void modifyTemplate(Set<String> tags, ApiTemplate template) {
        Profile profile = this.getPermission().getProfile();
        try {
            for (String tagName : tags) {
                this.im.getTagManager().addTag(tagName, (WebSearchable)template, profile);
            }
        }
        catch (TagManager.TagNameException e) {
            throw new BadRequestException(e.getMessage());
        }
        catch (TagManager.TagNamePermissionException e) {
            throw new ServiceForbiddenException(e.getMessage());
        }
    }

    private Set<String> getTags() {
        String[] tagValues = this.request.getParameterValues(TAGS);
        if (tagValues == null) {
            throw new BadRequestException("No tags supplied");
        }
        HashSet<String> tags = new HashSet<String>();
        for (String tagValue : tagValues) {
            String[] subvalues = StringUtils.split((String)tagValue, (char)';');
            Collections.addAll(tags, subvalues);
        }
        return tags;
    }
}

