/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.intermine.api.InterMineAPI;
import org.intermine.api.profile.Profile;
import org.intermine.api.userprofile.PermanentToken;
import org.intermine.api.userprofile.UserProfile;
import org.intermine.webservice.server.core.ReadWriteJSONService;
import org.intermine.webservice.server.user.PermaTokens;

public class TokensService
extends ReadWriteJSONService {
    public TokensService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        Profile profile = this.getPermission().getProfile();
        ArrayList<Map> tokens = new ArrayList<Map>();
        if (profile.getUserId() != null) {
            UserProfile up = (UserProfile)this.im.getProfileManager().getProfileObjectStoreWriter().getObjectById(profile.getUserId());
            String type = this.getOptionalParameter("type");
            if (type == null || "perm".equals(type)) {
                for (PermanentToken t : up.getPermanentTokens()) {
                    tokens.add(PermaTokens.format((PermanentToken)t));
                }
            } else if ("api".equals(type)) {
                String apiKey;
                if (up.getApiKey() == null) {
                    this.im.getProfileManager().generateApiKey(profile);
                }
                if ((apiKey = up.getApiKey()) != null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("token", apiKey);
                    tokens.add(map);
                }
            }
        }
        this.addResultItem(tokens, false);
    }

    protected String getResultsKey() {
        return "tokens";
    }
}

