/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.widget;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.intermine.api.InterMineAPI;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.export.ResponseUtil;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.webservice.server.core.JSONService;
import org.intermine.webservice.server.output.Formatter;
import org.intermine.webservice.server.output.Output;
import org.intermine.webservice.server.output.StreamedOutput;
import org.intermine.webservice.server.widget.AvailableWidgetsService;
import org.intermine.webservice.server.widget.FlatWidgetProcessor;
import org.intermine.webservice.server.widget.JSONWidgetProcessor;
import org.intermine.webservice.server.widget.WidgetProcessor;
import org.intermine.webservice.server.widget.XMLWidgetProcessor;

public class AvailableWidgetsService
extends JSONService {
    public AvailableWidgetsService(InterMineAPI im) {
        super(im);
    }

    protected void execute() throws Exception {
        WebConfig webConfig = InterMineContext.getWebConfig();
        Map widgetDetails = webConfig.getWidgets();
        WidgetProcessor processor = this.getProcessor();
        Iterator it = widgetDetails.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry pair = it.next();
            List row = processor.process((String)pair.getKey(), (WidgetConfig)pair.getValue());
            if (!this.formatIsFlatFile() && it.hasNext()) {
                row.add("");
            }
            this.output.addResultItem(row);
        }
    }

    protected Map<String, Object> getHeaderAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.putAll(super.getHeaderAttributes());
        if (this.formatIsJSON()) {
            attributes.put("intro", "\"widgets\":[");
            attributes.put("outro", "]");
        }
        return attributes;
    }

    private WidgetProcessor getProcessor() {
        if (this.formatIsJSON()) {
            return JSONWidgetProcessor.instance();
        }
        if (this.formatIsXML()) {
            return XMLWidgetProcessor.instance();
        }
        return FlatWidgetProcessor.instance();
    }

    protected Output makeXMLOutput(PrintWriter out, String separator) {
        ResponseUtil.setXMLHeader((HttpServletResponse)this.response, (String)"result.xml");
        return new StreamedOutput(out, (Formatter)new WidgetXMLFormatter(this, null));
    }
}

