/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.widget;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.intermine.webservice.server.widget.WidgetResultProcessor;

public class GraphXMLProcessor
implements WidgetResultProcessor {
    private boolean headerPrinted = false;

    public List<String> formatRow(List<Object> row) {
        String cellTag = this.headerPrinted ? "i" : "h";
        String rowTag = this.headerPrinted ? "result" : "header";
        this.headerPrinted = true;
        StringBuilder sb = new StringBuilder("<" + rowTag + ">");
        sb.append(this.formatCell(cellTag, row));
        sb.append("</" + rowTag + ">");
        return new LinkedList<String>(Arrays.asList(sb.toString()));
    }

    private String formatCell(String name, Object contents) {
        StringBuffer sb = new StringBuffer();
        if (contents instanceof List) {
            for (Object o : (List)contents) {
                sb.append(this.formatCell(name, o));
            }
        } else {
            sb.append("<" + name + ">");
            sb.append(StringEscapeUtils.escapeXml((String)contents.toString()));
            sb.append("</" + name + ">");
        }
        return sb.toString();
    }
}

