/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.webservice.server.widget;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.intermine.web.logic.widget.config.EnrichmentWidgetConfig;
import org.intermine.web.logic.widget.config.GraphWidgetConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;
import org.intermine.webservice.server.widget.WidgetProcessor;
import org.intermine.webservice.server.widget.WidgetProcessorImpl;
import org.json.JSONObject;

public final class JSONWidgetProcessor
extends WidgetProcessorImpl {
    private static final WidgetProcessor INSTANCE = new JSONWidgetProcessor();

    private JSONWidgetProcessor() {
    }

    public static WidgetProcessor instance() {
        return INSTANCE;
    }

    public List<String> process(String name, WidgetConfig widgetConfig) {
        HashMap<String, Object> backingMap = new HashMap<String, Object>();
        backingMap.put("name", name);
        backingMap.put("title", widgetConfig.getTitle());
        backingMap.put("description", widgetConfig.getDescription());
        backingMap.put("targets", this.getClasses(widgetConfig.getTypeClass()));
        backingMap.put("filters", widgetConfig.getFilters());
        backingMap.put("startClass", widgetConfig.getStartClass());
        WidgetProcessorImpl.WidgetType widgetType = this.getWidgetType(widgetConfig);
        backingMap.put("widgetType", widgetType.name().toLowerCase());
        if (widgetType == WidgetProcessorImpl.WidgetType.CHART) {
            backingMap.put("chartType", ((GraphWidgetConfig)widgetConfig).getGraphType());
            backingMap.put("labels", this.getLabels((GraphWidgetConfig)widgetConfig));
        }
        if (widgetType == WidgetProcessorImpl.WidgetType.ENRICHMENT) {
            backingMap.put("enrich", ((EnrichmentWidgetConfig)widgetConfig).getEnrich());
            backingMap.put("enrichIdentifier", ((EnrichmentWidgetConfig)widgetConfig).getEnrichIdentifier());
            backingMap.put("startClassDisplay", ((EnrichmentWidgetConfig)widgetConfig).getStartClassDisplay());
        }
        return new LinkedList<String>(Arrays.asList(new JSONObject(backingMap).toString()));
    }

    private List<String> getClasses(String tc) {
        LinkedList<String> ret = new LinkedList<String>();
        for (String s : StringUtils.split((String)tc, (String)",")) {
            ret.add(s);
        }
        return ret;
    }
}

