/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.dwr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.queryParser.ParseException;
import org.apache.struts.util.MessageResources;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.intermine.InterMineException;
import org.intermine.api.InterMineAPI;
import org.intermine.api.bag.BagManager;
import org.intermine.api.bag.TypeConverter;
import org.intermine.api.bag.UnknownBagTypeException;
import org.intermine.api.beans.PartnerLink;
import org.intermine.api.mines.FriendlyMineManager;
import org.intermine.api.mines.Mine;
import org.intermine.api.mines.ObjectRequest;
import org.intermine.api.profile.BagDoesNotExistException;
import org.intermine.api.profile.InterMineBag;
import org.intermine.api.profile.Profile;
import org.intermine.api.profile.ProfileAlreadyExistsException;
import org.intermine.api.profile.ProfileManager;
import org.intermine.api.profile.SavedQuery;
import org.intermine.api.profile.TagManager;
import org.intermine.api.profile.Taggable;
import org.intermine.api.profile.UserAlreadyShareBagException;
import org.intermine.api.profile.UserNotFoundException;
import org.intermine.api.query.WebResultsExecutor;
import org.intermine.api.results.WebTable;
import org.intermine.api.search.SearchRepository;
import org.intermine.api.search.SearchResult;
import org.intermine.api.search.SearchResults;
import org.intermine.api.search.SearchTarget;
import org.intermine.api.search.TagFilter;
import org.intermine.api.search.WebSearchable;
import org.intermine.api.template.ApiTemplate;
import org.intermine.api.template.TemplateManager;
import org.intermine.api.template.TemplateSummariser;
import org.intermine.api.types.ClassKeys;
import org.intermine.api.util.NameUtil;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.ReferenceDescriptor;
import org.intermine.metadata.StringUtil;
import org.intermine.metadata.TypeUtil;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.pathquery.Constraints;
import org.intermine.pathquery.OrderDirection;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathConstraint;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.pathquery.PathQueryBinding;
import org.intermine.template.TemplateQuery;
import org.intermine.util.Emailer;
import org.intermine.web.autocompletion.AutoCompleter;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.context.MailAction;
import org.intermine.web.displayer.InterMineLinkGenerator;
import org.intermine.web.logic.PortalHelper;
import org.intermine.web.logic.bag.BagConverter;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.profile.UpgradeBagList;
import org.intermine.web.logic.query.PageTableQueryMonitor;
import org.intermine.web.logic.query.QueryMonitorTimeout;
import org.intermine.web.logic.results.PagedTable;
import org.intermine.web.logic.results.WebState;
import org.intermine.web.logic.session.QueryCountQueryMonitor;
import org.intermine.web.logic.session.SessionMethods;
import org.json.JSONException;
import org.json.JSONObject;

public class AjaxServices {
    protected static final Logger LOG = Logger.getLogger(AjaxServices.class);
    private static final Object ERROR_MSG = "Error happened during DWR ajax service.";
    private static final Set<String> NON_WS_TAG_TYPES = new HashSet<String>(Arrays.asList("class", "collection", "reference"));

    public void setFavourite(String name, String type, boolean isFavourite) {
        String nameCopy = name.replaceAll("#039;", "'");
        try {
            if (isFavourite) {
                AjaxServices.deleteTag("im:favourite", nameCopy, type);
            } else {
                AjaxServices.addTag("im:favourite", nameCopy, type);
            }
        }
        catch (Exception e) {
            AjaxServices.processException(e);
        }
    }

    private static void processException(Exception e) {
        LOG.error(ERROR_MSG, (Throwable)e);
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String preCompute(String templateName) {
        try {
            WebContext ctx = WebContextFactory.get();
            HttpSession session = ctx.getSession();
            InterMineAPI im = SessionMethods.getInterMineAPI(session);
            Profile profile = SessionMethods.getProfile(session);
            Map templates = profile.getSavedTemplates();
            TemplateQuery t = (TemplateQuery)templates.get(templateName);
            WebResultsExecutor executor = im.getWebResultsExecutor(profile);
            try {
                session.setAttribute("precomputing_" + templateName, (Object)"true");
                executor.precomputeTemplate(t);
            }
            catch (ObjectStoreException e) {
                LOG.error((Object)"Error while precomputing", (Throwable)e);
            }
            finally {
                session.removeAttribute("precomputing_" + templateName);
            }
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
        }
        return "precomputed";
    }

    public String summarise(String templateName) {
        try {
            WebContext ctx = WebContextFactory.get();
            HttpSession session = ctx.getSession();
            InterMineAPI im = SessionMethods.getInterMineAPI(session);
            Profile profile = SessionMethods.getProfile(session);
            Map templates = profile.getSavedTemplates();
            ApiTemplate template = (ApiTemplate)templates.get(templateName);
            TemplateSummariser summariser = im.getTemplateSummariser();
            try {
                session.setAttribute("summarising_" + templateName, (Object)"true");
                summariser.summarise(template);
            }
            catch (ObjectStoreException e) {
                LOG.error((Object)("Failed to summarise " + templateName), (Throwable)e);
            }
            catch (NullPointerException e) {
                NullPointerException e2 = new NullPointerException("No such template " + templateName);
                e2.initCause(e);
                throw e2;
            }
            finally {
                session.removeAttribute("summarising_" + templateName);
            }
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
        }
        return "summarised";
    }

    public String rename(String name, String type, String reName) throws Exception {
        try {
            String newName = reName.trim();
            WebContext ctx = WebContextFactory.get();
            HttpSession session = ctx.getSession();
            Profile profile = SessionMethods.getProfile(session);
            if (name.equals(newName) || StringUtils.isEmpty((String)newName)) {
                return name;
            }
            if (!NameUtil.isValidName((String)newName)) {
                return "<i>Names for lists and queries may only contain A-Z, a-z, 0-9, underscores and dashes.</i>";
            }
            if ("history".equals(type)) {
                if (profile.getHistory().get(name) == null) {
                    return "<i>" + name + " does not exist</i>";
                }
                if (profile.getHistory().get(newName) != null) {
                    return "<i>" + newName + " already exists</i>";
                }
                profile.renameHistory(name, newName);
            } else if ("saved".equals(type)) {
                if (profile.getSavedQueries().get(name) == null) {
                    return "<i>" + name + " does not exist</i>";
                }
                if (profile.getSavedQueries().get(newName) != null) {
                    return "<i>" + newName + " already exists</i>";
                }
                SavedQuery sq = (SavedQuery)profile.getSavedQueries().get(name);
                profile.deleteQuery(sq.getName());
                sq = new SavedQuery(newName, sq.getDateCreated(), sq.getPathQuery());
                profile.saveQuery(sq.getName(), sq);
            } else if ("bag".equals(type)) {
                try {
                    profile.renameBag(name, newName);
                }
                catch (IllegalArgumentException e) {
                    return "<i>" + name + " does not exist</i>";
                }
                catch (ProfileAlreadyExistsException e) {
                    return "<i>" + newName + " already exists</i>";
                }
            } else if ("invalid.bag.type".equals(type)) {
                try {
                    profile.fixInvalidBag(name, newName);
                    InterMineAPI im = SessionMethods.getInterMineAPI(session);
                    new Thread(new UpgradeBagList(profile, im.getBagQueryRunner())).start();
                }
                catch (UnknownBagTypeException e) {
                    return "<i>" + e.getMessage() + "</i>";
                }
                catch (ObjectStoreException e) {
                    return "<i>Error fixing type</i>";
                }
            } else {
                return "Type unknown";
            }
            return newName;
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
            return null;
        }
    }

    public String generateApiKey(String username) throws Exception {
        try {
            WebContext ctx = WebContextFactory.get();
            HttpSession session = ctx.getSession();
            InterMineAPI im = SessionMethods.getInterMineAPI(session);
            ProfileManager pm = im.getProfileManager();
            Profile p = pm.getProfile(username);
            return pm.generateApiKey(p);
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
            return null;
        }
    }

    public String deleteApiKey(String username) throws Exception {
        try {
            WebContext ctx = WebContextFactory.get();
            HttpSession session = ctx.getSession();
            InterMineAPI im = SessionMethods.getInterMineAPI(session);
            ProfileManager pm = im.getProfileManager();
            Profile p = pm.getProfile(username);
            p.setApiKey(null);
            return "deleted";
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
            return null;
        }
    }

    public String saveBagDescription(String bagName, String description) throws Exception {
        try {
            WebContext ctx = WebContextFactory.get();
            HttpSession session = ctx.getSession();
            Profile profile = SessionMethods.getProfile(session);
            InterMineBag bag = (InterMineBag)profile.getSavedBags().get(bagName);
            if (bag == null) {
                throw new InterMineException("List \"" + bagName + "\" not found.");
            }
            bag.setDescription(StringEscapeUtils.escapeHtml((String)description));
            return description;
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
            return null;
        }
    }

    public String changeViewPathDescription(String pathString, String description) {
        try {
            String descr = description;
            if (description.trim().length() == 0) {
                descr = null;
            }
            WebContext ctx = WebContextFactory.get();
            HttpSession session = ctx.getSession();
            PathQuery query = SessionMethods.getQuery(session);
            Path path = query.makePath(pathString);
            Path prefixPath = path.getPrefix();
            if (descr == null) {
                query.setDescription(prefixPath.getNoConstraintsString(), null);
            } else {
                query.setDescription(prefixPath.getNoConstraintsString(), descr);
            }
            if (descr == null) {
                return null;
            }
            return descr.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
            return null;
        }
        catch (PathException e) {
            AjaxServices.processException((Exception)((Object)e));
            return null;
        }
    }

    private static WebState getWebState() {
        HttpSession session = WebContextFactory.get().getSession();
        return SessionMethods.getWebState(session);
    }

    public static String getToggledElements() {
        HttpSession session = WebContextFactory.get().getSession();
        WebState webState = SessionMethods.getWebState(session);
        HashSet<JSONObject> lists = new HashSet<JSONObject>();
        try {
            for (Map.Entry<String, Boolean> entry : webState.getToggledElements().entrySet()) {
                JSONObject list = new JSONObject();
                list.put("id", (Object)entry.getKey());
                list.put("opened", (Object)entry.getValue().toString());
                lists.add(list);
            }
        }
        catch (JSONException jse) {
            LOG.error((Object)"Errors generating json objects", (Throwable)jse);
        }
        return ((Object)lists).toString();
    }

    public static List<? extends Object> getColumnSummary(String tableName, String summaryPath) throws Exception {
        try {
            WebContext ctx = WebContextFactory.get();
            HttpSession session = ctx.getSession();
            InterMineAPI im = SessionMethods.getInterMineAPI(session);
            Profile profile = SessionMethods.getProfile(session);
            WebResultsExecutor webResultsExecutor = im.getWebResultsExecutor(profile);
            WebTable webTable = SessionMethods.getResultsTable(session, tableName).getWebTable();
            PathQuery pathQuery = webTable.getPathQuery();
            Results results = webResultsExecutor.summariseQuery(pathQuery, summaryPath);
            Query countQuery = webResultsExecutor.makeSummaryQuery(pathQuery, summaryPath);
            QueryCountQueryMonitor clientState = new QueryCountQueryMonitor(20000, countQuery);
            MessageResources messages = (MessageResources)ctx.getHttpServletRequest().getAttribute("org.apache.struts.action.MESSAGE");
            String qid = SessionMethods.startQueryCount(clientState, session, messages);
            ArrayList<ResultsRow> pageSizeResults = new ArrayList<ResultsRow>();
            int rowCount = 0;
            for (ResultsRow row : results) {
                if (++rowCount > 10) break;
                pageSizeResults.add(row);
            }
            return Arrays.asList(pageSizeResults, qid, new Integer(rowCount));
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
            return null;
        }
    }

    public static Integer getResultsSize(String qid) {
        try {
            WebContext ctx = WebContextFactory.get();
            HttpSession session = ctx.getSession();
            QueryMonitorTimeout controller = (QueryMonitorTimeout)SessionMethods.getRunningQueryController(qid, session);
            if (controller == null) {
                return null;
            }
            controller.tickle();
            if (controller.isCancelledWithError()) {
                LOG.debug((Object)("query qid " + qid + " error"));
                return null;
            }
            if (controller.isCancelled()) {
                LOG.debug((Object)("query qid " + qid + " cancelled"));
                return null;
            }
            if (controller.isCompleted()) {
                LOG.debug((Object)("query qid " + qid + " complete"));
                if (controller instanceof PageTableQueryMonitor) {
                    PagedTable pt = ((PageTableQueryMonitor)controller).getPagedTable();
                    return new Integer(pt.getExactSize());
                }
                if (controller instanceof QueryCountQueryMonitor) {
                    return new Integer(((QueryCountQueryMonitor)controller).getCount());
                }
                LOG.debug((Object)("query qid " + qid + " - unknown controller type"));
                return null;
            }
            LOG.debug((Object)("query qid " + qid + " still running, making client wait"));
            return null;
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
            return null;
        }
    }

    public static List<? extends Object> filterWebSearchables(String scope, String type, List<String> tags, String filterText, String filterAction, String callId) {
        try {
            SearchResults results;
            HttpSession session = WebContextFactory.get().getSession();
            InterMineAPI im = SessionMethods.getInterMineAPI(session);
            ProfileManager pm = im.getProfileManager();
            Profile profile = SessionMethods.getProfile(session);
            SearchRepository userRepository = profile.getSearchRepository();
            SearchTarget target = new SearchTarget(scope, type);
            try {
                results = SearchResults.runLuceneSearch((String)filterText, (SearchTarget)target, (SearchRepository)userRepository);
            }
            catch (ParseException e) {
                LOG.error((Object)"couldn't run lucene filter", (Throwable)e);
                return Arrays.asList(callId);
            }
            catch (IOException e) {
                LOG.error((Object)"couldn't run lucene filter", (Throwable)e);
                return Arrays.asList(callId);
            }
            ArrayList<String> aspectTags = new ArrayList<String>();
            ArrayList<String> userTags = new ArrayList<String>();
            for (String tag : tags) {
                if (tag.startsWith("im:aspect:")) {
                    aspectTags.add(tag);
                    continue;
                }
                if (profile.getUsername() == null) continue;
                userTags.add(tag);
            }
            TagFilter aspects = new TagFilter(aspectTags, pm.getSuperuserProfile(), type);
            TagFilter requiredTags = new TagFilter(userTags, profile, type);
            ArrayList<Object> returnList = new ArrayList<Object>();
            returnList.add(callId);
            for (SearchResult sr : results) {
                WebSearchable ws = sr.getItem();
                if (SearchResults.isInvalidTemplate((WebSearchable)ws) || !aspects.hasAllTags((Taggable)ws) || !requiredTags.hasAllTags((Taggable)ws)) continue;
                returnList.add(sr.asList());
            }
            return returnList;
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
            return null;
        }
    }

    public static int getConvertCountForBag(String bagName, String type) {
        try {
            HttpSession session = WebContextFactory.get().getSession();
            InterMineAPI im = SessionMethods.getInterMineAPI(session);
            String pckName = im.getModel().getPackageName();
            Profile profile = SessionMethods.getProfile(session);
            BagManager bagManager = im.getBagManager();
            TemplateManager templateManager = im.getTemplateManager();
            WebResultsExecutor webResultsExecutor = im.getWebResultsExecutor(profile);
            int count = 0;
            InterMineBag imBag = bagManager.getBag(profile, bagName);
            List conversionTemplates = templateManager.getConversionTemplates();
            String bagTypeName = pckName + "." + imBag.getType();
            Class fromType = TypeUtil.instantiate((String)bagTypeName);
            Class toType = TypeUtil.instantiate((String)(pckName + "." + type));
            PathQuery pathQuery = TypeConverter.getConversionQuery((List)conversionTemplates, (Class)fromType, (Class)toType, (Object)imBag);
            count = webResultsExecutor.count(pathQuery);
            return count;
        }
        catch (Exception e) {
            LOG.error((Object)"failed to get type converted counts", (Throwable)e);
            return 0;
        }
    }

    public static String getCustomConverterCounts(String bagName, String converterName) {
        try {
            HttpSession session = WebContextFactory.get().getSession();
            InterMineAPI im = SessionMethods.getInterMineAPI(session);
            Profile profile = SessionMethods.getProfile(session);
            BagManager bagManager = im.getBagManager();
            InterMineBag imBag = bagManager.getBag(profile, bagName);
            ServletContext servletContext = WebContextFactory.get().getServletContext();
            WebConfig webConfig = SessionMethods.getWebConfig(servletContext);
            BagConverter bagConverter = PortalHelper.getBagConverter(im, webConfig, converterName);
            Map<String, String> results = bagConverter.getCounts(profile, imBag);
            LinkedList<JSONObject> jsonResults = new LinkedList<JSONObject>();
            for (Map.Entry<String, String> entry : results.entrySet()) {
                JSONObject organism = new JSONObject();
                organism.put("name", (Object)entry.getKey());
                organism.put("count", (Object)entry.getValue());
                jsonResults.add(organism);
            }
            return ((Object)jsonResults).toString();
        }
        catch (Exception e) {
            LOG.error((Object)"failed to get custom converter counts", (Throwable)e);
            return null;
        }
    }

    public static Collection<PartnerLink> getFriendlyMineLinks(String mineName, String domains, String idents) {
        if (StringUtils.isEmpty((String)mineName) || StringUtils.isEmpty((String)domains) || StringUtils.isEmpty((String)idents)) {
            return null;
        }
        HttpSession session = WebContextFactory.get().getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        ServletContext servletContext = WebContextFactory.get().getServletContext();
        Properties webProperties = SessionMethods.getWebProperties(servletContext);
        FriendlyMineManager fmm = FriendlyMineManager.getInstance((InterMineAPI)im, (Properties)webProperties);
        String linkGeneratorClass = webProperties.getProperty("friendlymines.linkgenerator");
        Mine mine = fmm.getMine(mineName);
        Collection<Object> results = Collections.emptySet();
        if (mine == null || mine.getReleaseVersion() == null) {
            LOG.error((Object)(mineName + " seems to be dead"));
        } else {
            InterMineLinkGenerator linkGen;
            LOG.debug((Object)(mine.getName() + " is at " + mine.getReleaseVersion()));
            ObjectRequest req = new ObjectRequest(domains, idents);
            MultiKey key = new MultiKey((Object)mine.getName(), (Object)req);
            results = fmm.getLinks(key);
            if (results == null && (linkGen = (InterMineLinkGenerator)TypeUtil.createNew((String)linkGeneratorClass)) != null) {
                results = linkGen.getLinks(fmm.getLocalMine(), mine, req);
            }
            fmm.cacheLinks(key, results);
        }
        LOG.debug((Object)("Links: " + results));
        return results;
    }

    private static String getXMLQuery(String filename, Object ... positionalArgs) {
        try {
            return String.format(IOUtils.toString((InputStream)AjaxServices.class.getResourceAsStream(filename)), positionalArgs);
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new RuntimeException("Could not read " + filename, e);
        }
        catch (NullPointerException npe) {
            LOG.error((Object)npe);
            throw new RuntimeException(filename + " not found", npe);
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            throw new RuntimeException("Unexpected exception " + e.getMessage());
        }
    }

    public static Map<String, Object> getRatDiseases(String orthologues) {
        ServletContext servletContext;
        Properties webProperties;
        if (StringUtils.isEmpty((String)orthologues)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        HttpSession session = WebContextFactory.get().getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        FriendlyMineManager mines = FriendlyMineManager.getInstance((InterMineAPI)im, (Properties)(webProperties = SessionMethods.getWebProperties(servletContext = WebContextFactory.get().getServletContext())));
        Mine ratMine = mines.getMine("RatMine");
        if (ratMine == null || ratMine.getReleaseVersion() == null) {
            map.put("status", "offline");
            return map;
        }
        map.put("status", "online");
        map.put("mineURL", ratMine.getUrl());
        String xmlQuery = AjaxServices.getXMLQuery("RatDiseases.xml", new Object[0]);
        PathQuery pq = PathQueryBinding.unmarshalPathQuery((Reader)new StringReader(xmlQuery), (int)2, (Model)ratMine.getModel());
        pq.addConstraint((PathConstraint)Constraints.lookup((String)"Gene", (String)orthologues, null));
        map.put("results", ratMine.getRows(pq));
        return map;
    }

    public static void saveToggleState(String elementId, boolean opened) {
        try {
            AjaxServices.getWebState().getToggledElements().put(elementId, opened);
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
        }
    }

    public static void setState(String name, String value) {
        try {
            AjaxServices.getWebState().setState(name, value);
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
        }
    }

    public static String validateBagName(String bagName) {
        try {
            HttpSession session = WebContextFactory.get().getSession();
            InterMineAPI im = SessionMethods.getInterMineAPI(session);
            Profile profile = SessionMethods.getProfile(session);
            BagManager bagManager = im.getBagManager();
            bagName = bagName.trim();
            if ("".equals(bagName)) {
                return "You cannot save a list with a blank name";
            }
            if (!NameUtil.isValidName((String)bagName)) {
                return "Invalid name. Names may only contain letters, numbers, spaces, full stops, hyphens and colons.";
            }
            if (profile.getSavedBags().get(bagName) != null) {
                return "The list name you have chosen is already in use";
            }
            if (bagManager.getGlobalBag(bagName) != null) {
                return "The list name you have chosen is already in use - there is a public list called " + bagName;
            }
            return "";
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
            return null;
        }
    }

    public static String validateBagOperations(String bagName, String[] selectedBags, String operation) {
        try {
            ServletContext servletContext = WebContextFactory.get().getServletContext();
            HttpSession session = WebContextFactory.get().getSession();
            Profile profile = SessionMethods.getProfile(session);
            if (selectedBags.length == 0) {
                return "No lists are selected";
            }
            if ("delete".equals(operation)) {
                for (int i = 0; i < selectedBags.length; ++i) {
                    HashSet<String> queries = new HashSet<String>();
                    queries.addAll(AjaxServices.queriesThatMentionBag(profile.getSavedQueries(), selectedBags[i]));
                    queries.addAll(AjaxServices.queriesThatMentionBag(profile.getHistory(), selectedBags[i]));
                    if (queries.size() <= 0) continue;
                    String msg = "You are trying to delete the list:  `" + selectedBags[i] + "`, which is used by these queries: " + queries + ".  Select OK to delete the list and queries or Cancel to cancel this operation.";
                    return msg;
                }
            } else if (!"copy".equals(operation)) {
                Properties properties = SessionMethods.getWebProperties(servletContext);
                String defaultName = properties.getProperty("lists.input.example");
                if (bagName.equalsIgnoreCase(defaultName)) {
                    return "New list name is required";
                }
                if ("".equals(bagName)) {
                    return "Please enter a name for your new list";
                }
                if (!NameUtil.isValidName((String)bagName)) {
                    return "Names for lists and queries may only contain A-Z, a-z, 0-9, underscores and dashes.";
                }
            }
            return "";
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
            return null;
        }
    }

    private static List<String> queriesThatMentionBag(Map<String, SavedQuery> savedQueries, String bagName) {
        try {
            ArrayList<String> queries = new ArrayList<String>();
            for (String queryName : savedQueries.keySet()) {
                SavedQuery query = savedQueries.get(queryName);
                if (!query.getPathQuery().getBagNames().contains(bagName)) continue;
                queries.add(queryName);
            }
            return queries;
        }
        catch (RuntimeException e) {
            AjaxServices.processException(e);
            return null;
        }
    }

    public static List<String> selectId(String selectedId, String tableId, String columnIndex) {
        WebContext ctx = WebContextFactory.get();
        HttpSession session = ctx.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        PagedTable pt = SessionMethods.getResultsTable(session, tableId);
        pt.selectId(new Integer(selectedId), new Integer(columnIndex));
        ClassKeys classKeys = im.getClassKeys();
        ObjectStore os = im.getObjectStore();
        return pt.getFirstSelectedFields(os, (Map<String, List<FieldDescriptor>>)classKeys);
    }

    public static List<String> deSelectId(String deSelectId, String tableId) {
        WebContext ctx = WebContextFactory.get();
        HttpSession session = ctx.getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        PagedTable pt = SessionMethods.getResultsTable(session, tableId);
        pt.deSelectId(new Integer(deSelectId));
        ClassKeys classKeys = im.getClassKeys();
        ObjectStore os = im.getObjectStore();
        return pt.getFirstSelectedFields(os, (Map<String, List<FieldDescriptor>>)classKeys);
    }

    public static void selectAll(int index, String tableId) {
        HttpSession session = WebContextFactory.get().getSession();
        PagedTable pt = SessionMethods.getResultsTable(session, tableId);
        pt.clearSelectIds();
        pt.setAllSelectedColumn(index);
    }

    public void reorder(String newOrder, String oldOrder) {
        HttpSession session = WebContextFactory.get().getSession();
        LinkedList newOrderList = new LinkedList(StringUtil.serializedSortOrderToMap((String)newOrder).values());
        LinkedList oldOrderList = new LinkedList(StringUtil.serializedSortOrderToMap((String)oldOrder).values());
        List<String> view = SessionMethods.getEditingView(session);
        ArrayList<String> newView = new ArrayList<String>();
        for (int i = 0; i < view.size(); ++i) {
            String newi = (String)newOrderList.get(i);
            int oldi = oldOrderList.indexOf(newi);
            newView.add(view.get(oldi));
        }
        PathQuery query = SessionMethods.getQuery(session);
        query.clearView();
        query.addViews(newView);
    }

    public void reorderConstraints(String newOrder, String oldOrder) {
        HttpSession session = WebContextFactory.get().getSession();
        LinkedList newOrderList = new LinkedList(StringUtil.serializedSortOrderToMap((String)newOrder).values());
        LinkedList oldOrderList = new LinkedList(StringUtil.serializedSortOrderToMap((String)oldOrder).values());
        PathQuery query = SessionMethods.getQuery(session);
        if (query instanceof TemplateQuery) {
            TemplateQuery template = (TemplateQuery)query;
            for (int index = 0; index < newOrderList.size() - 1; ++index) {
                String newi = (String)newOrderList.get(index);
                int oldi = oldOrderList.indexOf(newi);
                if (index == oldi) continue;
                List editableConstraints = template.getModifiableEditableConstraints();
                PathConstraint editableConstraint = (PathConstraint)editableConstraints.remove(oldi);
                editableConstraints.add(index, editableConstraint);
                template.setEditableConstraints(editableConstraints);
                break;
            }
        }
    }

    public void addToSortOrder(String path, String direction) throws Exception {
        HttpSession session = WebContextFactory.get().getSession();
        PathQuery query = SessionMethods.getQuery(session);
        OrderDirection orderDirection = OrderDirection.ASC;
        if ("DESC".equals(direction.toUpperCase())) {
            orderDirection = OrderDirection.DESC;
        }
        query.clearOrderBy();
        query.addOrderBy(path, orderDirection);
    }

    public static String getNewsPreview(String rssURL) {
        try {
            String str;
            URL url = new URL(rssURL);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuffer sb = new StringBuffer();
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
            in.close();
            return sb.toString();
        }
        catch (MalformedURLException e) {
            return "";
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String addTag(String tag, String taggedObject, String type) {
        String tagName = tag;
        LOG.info((Object)("Called addTag(). tagName:" + tagName + " taggedObject:" + taggedObject + " type: " + type));
        if (StringUtils.isBlank((String)tagName)) {
            LOG.error((Object)"Adding tag failed");
            return "tag must not be blank";
        }
        if (StringUtils.isBlank((String)taggedObject)) {
            LOG.error((Object)"Adding tag failed");
            return "object to tag must not be blank";
        }
        try {
            HttpServletRequest request = AjaxServices.getRequest();
            Profile profile = AjaxServices.getProfile(request);
            InterMineAPI im = SessionMethods.getInterMineAPI(request);
            tagName = tagName.trim();
            if (!(profile.getUsername() == null || StringUtils.isEmpty((String)tagName) || StringUtils.isEmpty((String)type) || StringUtils.isEmpty((String)taggedObject))) {
                if (AjaxServices.tagExists(tagName, taggedObject, type)) {
                    return "Already tagged with this tag.";
                }
                TagManager tagManager = AjaxServices.getTagManager();
                BagManager bm = im.getBagManager();
                TemplateManager tm = im.getTemplateManager();
                if (NON_WS_TAG_TYPES.contains(type)) {
                    if ("class".equals(type)) {
                        ClassDescriptor cd = im.getModel().getClassDescriptorByName(taggedObject);
                        tagManager.addTag(tagName, cd, profile);
                    } else {
                        String[] bits = taggedObject.split("\\.");
                        ClassDescriptor cd = im.getModel().getClassDescriptorByName(bits[0]);
                        FieldDescriptor fd = cd.getFieldDescriptorByName(bits[1]);
                        if (fd.isCollection() || fd.isReference()) {
                            tagManager.addTag(tagName, (ReferenceDescriptor)fd, profile);
                        }
                    }
                } else {
                    InterMineBag ws = null;
                    if ("bag".equals(type)) {
                        ws = bm.getBag(profile, taggedObject);
                    } else if ("template".equals(type)) {
                        ws = tm.getUserOrGlobalTemplate(profile, taggedObject);
                    }
                    if (ws == null) {
                        throw new RuntimeException("Could not find " + type + " " + taggedObject);
                    }
                    tagManager.addTag(tagName, (WebSearchable)ws, profile);
                }
                return "ok";
            }
            LOG.error((Object)("Adding tag failed: tag='" + tag + "', taggedObject='" + taggedObject + "', type='" + type + "'"));
            return "Adding tag failed.";
        }
        catch (TagManager.TagNamePermissionException e) {
            LOG.error((Object)"Adding tag failed", (Throwable)e);
            return e.getMessage();
        }
        catch (TagManager.TagNameException e) {
            LOG.error((Object)"Adding tag failed", (Throwable)e);
            return e.getMessage();
        }
        catch (Throwable e) {
            LOG.error((Object)"Adding tag failed", e);
            return "Adding tag failed.";
        }
    }

    public static String deleteTag(String tagName, String tagged, String type) {
        LOG.info((Object)("Called deleteTag(). tagName:" + tagName + " taggedObject:" + tagged + " type: " + type));
        try {
            HttpServletRequest request = AjaxServices.getRequest();
            HttpSession session = request.getSession();
            InterMineAPI im = SessionMethods.getInterMineAPI(session);
            Profile profile = AjaxServices.getProfile(request);
            TagManager manager = im.getTagManager();
            BagManager bm = im.getBagManager();
            TemplateManager tm = im.getTemplateManager();
            if (NON_WS_TAG_TYPES.contains(type)) {
                if ("class".equals(type)) {
                    ClassDescriptor cd = im.getModel().getClassDescriptorByName(tagged);
                    manager.deleteTag(tagName, cd, profile);
                } else {
                    String[] bits = tagged.split("\\.");
                    ClassDescriptor cd = im.getModel().getClassDescriptorByName(bits[0]);
                    FieldDescriptor fd = cd.getFieldDescriptorByName(bits[1]);
                    if (fd.isCollection() || fd.isReference()) {
                        manager.deleteTag(tagName, (ReferenceDescriptor)fd, profile);
                    }
                }
                return "ok";
            }
            InterMineBag ws = null;
            if ("bag".equals(type)) {
                ws = bm.getBag(profile, tagged);
            } else if ("template".equals(type)) {
                ws = tm.getUserOrGlobalTemplate(profile, tagged);
            }
            if (ws == null) {
                throw new RuntimeException("Could not find " + type + " " + tagged);
            }
            manager.deleteTag(tagName, (WebSearchable)ws, profile);
            return "ok";
        }
        catch (Throwable e) {
            LOG.error((Object)"Deleting tag failed", e);
            return "Deleting tag failed.";
        }
    }

    public static Set<String> getTags(String type) {
        HttpServletRequest request = AjaxServices.getRequest();
        InterMineAPI im = SessionMethods.getInterMineAPI(request.getSession());
        TagManager tagManager = im.getTagManager();
        Profile profile = AjaxServices.getProfile(request);
        if (profile.isLoggedIn()) {
            return tagManager.getUserTagNames(type, profile.getUsername());
        }
        return new TreeSet<String>();
    }

    public static Set<String> getObjectTags(String type, String tagged) {
        HttpServletRequest request = AjaxServices.getRequest();
        InterMineAPI im = SessionMethods.getInterMineAPI(request.getSession());
        TagManager tagManager = im.getTagManager();
        Profile profile = AjaxServices.getProfile(request);
        if (profile.isLoggedIn()) {
            return tagManager.getObjectTagNames(tagged, type, profile.getUsername());
        }
        return new TreeSet<String>();
    }

    private static boolean tagExists(String tag, String taggedObject, String type) {
        HttpServletRequest request = AjaxServices.getRequest();
        InterMineAPI im = SessionMethods.getInterMineAPI(request.getSession());
        TagManager tagManager = im.getTagManager();
        String userName = AjaxServices.getProfile(request).getUsername();
        return tagManager.getObjectTagNames(taggedObject, type, userName).contains(tag);
    }

    private static Profile getProfile(HttpServletRequest request) {
        return SessionMethods.getProfile(request.getSession());
    }

    public static String getSingleUseKey() {
        HttpServletRequest request = AjaxServices.getRequest();
        Profile profile = SessionMethods.getProfile(request.getSession());
        return profile.getSingleUseKey();
    }

    private static HttpServletRequest getRequest() {
        return WebContextFactory.get().getHttpServletRequest();
    }

    private static TagManager getTagManager() {
        HttpServletRequest request = AjaxServices.getRequest();
        InterMineAPI im = SessionMethods.getInterMineAPI(request.getSession());
        return im.getTagManager();
    }

    public static String setConstraintLogic(String expression) throws PathException {
        WebContext ctx = WebContextFactory.get();
        HttpSession session = ctx.getSession();
        PathQuery query = SessionMethods.getQuery(session);
        query.setConstraintLogic(expression);
        List messages = query.fixUpForJoinStyle();
        StringBuffer messagesToDisplay = new StringBuffer();
        for (String message : messages) {
            messagesToDisplay.append(message);
        }
        return messagesToDisplay.toString();
    }

    public static String getConstraintLogic() {
        WebContext ctx = WebContextFactory.get();
        HttpSession session = ctx.getSession();
        PathQuery query = SessionMethods.getQuery(session);
        return query.getConstraintLogic();
    }

    public String[] getContent(String suffix, boolean wholeList, String field, String className) {
        ServletContext servletContext = WebContextFactory.get().getServletContext();
        AutoCompleter ac = SessionMethods.getAutoCompleter(servletContext);
        suffix = suffix.replace("-", " ");
        String[] stringList = null;
        if (!wholeList && suffix.length() > 0) {
            stringList = ac.getFastList(suffix, field, className, 31);
        } else if (suffix.length() > 2 && wholeList) {
            stringList = ac.getFastList(suffix, field, className, 500);
        }
        if (stringList == null) {
            String[] defaultList = new String[]{""};
            return defaultList;
        }
        return stringList;
    }

    public String getSavedBagStatus() throws JSONException {
        HttpSession session = WebContextFactory.get().getSession();
        Map savedBags = SessionMethods.getProfile(session).getSavedBags();
        HashSet<JSONObject> lists = new HashSet<JSONObject>();
        try {
            for (Map.Entry entry : savedBags.entrySet()) {
                InterMineBag bag = (InterMineBag)entry.getValue();
                if (!bag.isCurrent() && !bag.isToUpgrade()) continue;
                JSONObject list = new JSONObject();
                list.put("name", entry.getKey());
                list.put("status", (Object)bag.getState());
                if (bag.isCurrent()) {
                    try {
                        list.put("size", bag.getSize());
                    }
                    catch (ObjectStoreException os) {
                        LOG.error((Object)("Problems retrieving size of bag " + bag.getName()), (Throwable)os);
                    }
                } else {
                    list.put("size", 0);
                }
                lists.add(list);
            }
        }
        catch (JSONException jse) {
            LOG.error((Object)"Errors generating json objects", (Throwable)jse);
        }
        return ((Object)lists).toString();
    }

    public void updateTemplate(String field, String value) {
        HttpSession session = WebContextFactory.get().getSession();
        boolean isNewTemplate = session.getAttribute("NEW_TEMPLATE") != null;
        TemplateQuery templateQuery = (TemplateQuery)SessionMethods.getQuery(session);
        if (!isNewTemplate && session.getAttribute("PREV_TEMPLATE_NAME") == null) {
            session.setAttribute("PREV_TEMPLATE_NAME", (Object)templateQuery.getName());
        }
        try {
            PropertyUtils.setSimpleProperty((Object)templateQuery, (String)field, (Object)value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String addUserToShareBag(String userName, String bagName) {
        HttpSession session = WebContextFactory.get().getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        final Profile profile = SessionMethods.getProfile(session);
        BagManager bagManager = im.getBagManager();
        ProfileManager pm = profile.getProfileManager();
        final InterMineBag bag = (InterMineBag)profile.getSavedBags().get(bagName);
        final Profile invitee = pm.getProfile(userName);
        if (bag == null) {
            return "This is not one of your lists";
        }
        if (invitee == null || invitee.getPreferences().containsKey("hidden")) {
            return "User not found.";
        }
        if (profile.getUsername().equals(userName)) {
            return "You are trying to share this with yourself.";
        }
        try {
            bagManager.shareBagWithUser(bag, invitee);
        }
        catch (UserNotFoundException e1) {
            return "User not found.";
        }
        catch (UserAlreadyShareBagException e2) {
            return "The user already shares the bag.";
        }
        boolean queuedMessage = InterMineContext.queueMessage(new MailAction(){

            @Override
            public void act(Emailer emailer) throws Exception {
                emailer.informUserOfNewSharedBag(invitee.getEmailAddress(), profile, bag);
            }
        });
        if (!queuedMessage) {
            LOG.warn((Object)"Message queue full.");
        }
        return "ok";
    }

    public String deleteUserToShareBag(String userName, String bagName) {
        HttpSession session = WebContextFactory.get().getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Profile profile = SessionMethods.getProfile(session);
        BagManager bagManager = im.getBagManager();
        try {
            bagManager.unshareBagWithUser(bagName, profile.getUsername(), userName);
        }
        catch (UserNotFoundException unfe) {
            return "User not found.";
        }
        catch (BagDoesNotExistException bnee) {
            return "That list does not exist.";
        }
        return "ok";
    }

    public Collection<String> getUsersSharingBag(String bagName) {
        HttpSession session = WebContextFactory.get().getSession();
        InterMineAPI im = SessionMethods.getInterMineAPI(session);
        Profile profile = SessionMethods.getProfile(session);
        BagManager bagManager = im.getBagManager();
        return bagManager.getUsersSharingBag(bagName, profile.getUsername());
    }
}

