/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.autocompletion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.objectstore.ObjectStore;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.objectstore.query.FromElement;
import org.intermine.objectstore.query.Query;
import org.intermine.objectstore.query.QueryClass;
import org.intermine.objectstore.query.QueryField;
import org.intermine.objectstore.query.QuerySelectable;
import org.intermine.objectstore.query.Results;
import org.intermine.objectstore.query.ResultsRow;
import org.intermine.web.autocompletion.PropertiesManager;
import org.intermine.web.autocompletion.SolrClientHandler;

public class AutoCompleter {
    private static final Logger LOG = Logger.getLogger(AutoCompleter.class);
    private PropertiesManager propertiesManager;
    private HashMap<String, String> classFieldMap = new HashMap();
    private HashMap<String, List<String>> fieldIndexMap = new HashMap();
    ObjectStore os;
    private static final String CLASSNAME_FIELD = "className";

    public AutoCompleter(ObjectStore os) {
        this.os = os;
        if (this.propertiesManager == null) {
            this.propertiesManager = PropertiesManager.getInstance();
            this.classFieldMap = this.propertiesManager.getClassFieldMap();
            this.createFieldIndexMap();
        }
    }

    public String[] getFastList(String query, String field, String className, int n) {
        String status = "true";
        String[] stringResults = null;
        SolrClient solrClient = SolrClientHandler.getClientInstance(this.propertiesManager.getSolrUrl());
        QueryResponse resp = null;
        if (!"".equals(query) && !query.trim().startsWith("*")) {
            if (query.endsWith(" ")) {
                query = query.substring(0, query.length() - 1);
            }
            if (query.contains(" ")) {
                String[] tmp = query.replaceAll(" +", " ").trim().split(" ");
                query = new String();
                for (int i = 0; i < tmp.length; ++i) {
                    query = query + tmp[i];
                    if (i >= tmp.length - 1) continue;
                    query = query + "* AND " + field + ":";
                }
            }
            try {
                SolrQuery newQuery = new SolrQuery();
                newQuery.setQuery(field + ":" + query + "*");
                newQuery.setRequestHandler("select");
                newQuery.setRows(Integer.valueOf(n));
                newQuery.setFilterQueries(new String[]{"className:" + className});
                resp = solrClient.query((SolrParams)newQuery);
                SolrDocumentList results = resp.getResults();
                stringResults = new String[results.size() + 1];
                for (int i = 1; i < results.size() + 1; ++i) {
                    try {
                        SolrDocument document = (SolrDocument)results.get(i - 1);
                        stringResults[i] = (String)((ArrayList)document.getFieldValue(field)).get(0);
                        continue;
                    }
                    catch (Exception e) {
                        status = "No results! Please try again.";
                    }
                }
                stringResults[0] = status;
                return stringResults;
            }
            catch (SolrServerException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
                status = "Please type in more characters to get results.";
                stringResults = new String[]{status};
            }
            return stringResults;
        }
        return null;
    }

    public void buildIndex(ObjectStore os) throws IOException, ObjectStoreException, ClassNotFoundException, SolrServerException {
        ArrayList<SolrInputDocument> solrDocumentList = new ArrayList<SolrInputDocument>();
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add(CLASSNAME_FIELD);
        for (Map.Entry<String, String> entry : this.classFieldMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String className = key;
            ClassDescriptor cld = os.getModel().getClassDescriptorByName(className);
            if (cld == null) {
                throw new RuntimeException("a class mentioned in ObjectStore summary properties file (" + className + ") is not in the model");
            }
            List<String> fieldNames = Arrays.asList(value.split(" "));
            for (String fieldName : fieldNames) {
                String classAndField = cld.getUnqualifiedName() + "." + fieldName;
                System.out.println("Indexing " + classAndField);
                if (!fieldList.contains(fieldName)) {
                    fieldList.add(fieldName);
                }
                Query q = new Query();
                q.setDistinct(true);
                QueryClass qc = new QueryClass(new Class[]{Class.forName(cld.getName())});
                q.addToSelect((QuerySelectable)new QueryField(qc, fieldName));
                q.addFrom((FromElement)qc);
                Results results = os.execute(q);
                for (Object resRow : results) {
                    Object fieldValue = ((ResultsRow)resRow).get(0);
                    if (fieldValue == null) continue;
                    SolrInputDocument solrInputDocument = new SolrInputDocument(new String[0]);
                    solrInputDocument.addField(fieldName, (Object)fieldValue.toString());
                    solrInputDocument.addField(CLASSNAME_FIELD, (Object)cld.getUnqualifiedName());
                    solrDocumentList.add(solrInputDocument);
                }
            }
        }
        SolrClient solrClient = SolrClientHandler.getClientInstance(this.propertiesManager.getSolrUrl());
        try {
            solrClient.deleteByQuery("*:*");
            solrClient.commit();
        }
        catch (SolrServerException e) {
            LOG.error((Object)"Deleting old index failed", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        List<String> existingFields = null;
        try {
            existingFields = this.getAllExistingFieldsFromSolr(solrClient);
        }
        catch (SolrServerException e) {
            LOG.error((Object)"Retrieving existing Fieldnames in Solr failed");
        }
        for (String fieldName : fieldList) {
            if (existingFields == null || existingFields.contains(fieldName)) continue;
            HashMap<String, Object> fieldAttributes = new HashMap<String, Object>();
            fieldAttributes.put("name", fieldName);
            fieldAttributes.put("type", "text_general");
            fieldAttributes.put("stored", true);
            fieldAttributes.put("indexed", true);
            fieldAttributes.put("multiValued", true);
            fieldAttributes.put("required", false);
            try {
                SchemaRequest.AddField schemaRequest = new SchemaRequest.AddField(fieldAttributes);
                SchemaResponse.UpdateResponse updateResponse = (SchemaResponse.UpdateResponse)schemaRequest.process(solrClient);
            }
            catch (SolrServerException e) {
                LOG.error((Object)"Error while adding autocomplete fields to the solrclient.", (Throwable)e);
                e.printStackTrace();
            }
        }
        try {
            if (!solrDocumentList.isEmpty()) {
                UpdateResponse response = solrClient.add(solrDocumentList);
                solrClient.commit();
            }
        }
        catch (SolrServerException e) {
            LOG.error((Object)"Error while commiting the AutoComplete SolrInputdocuments to the Solrclient. Make sure the Solr instance is up", (Throwable)e);
            e.printStackTrace();
        }
    }

    public boolean hasAutocompleter(String type, String field) {
        return this.fieldIndexMap.containsKey(type) && this.fieldIndexMap.get(type).contains(field);
    }

    private void createFieldIndexMap() {
        for (Map.Entry<String, String> entry : this.classFieldMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String className = key;
            ClassDescriptor cld = this.os.getModel().getClassDescriptorByName(className);
            if (cld == null) {
                throw new RuntimeException("a class mentioned in ObjectStore summary properties file (" + className + ") is not in the model");
            }
            List<String> fieldNames = Arrays.asList(value.split(" "));
            this.fieldIndexMap.put(cld.getUnqualifiedName(), fieldNames);
        }
    }

    private List<String> getAllExistingFieldsFromSolr(SolrClient solrClient) throws IOException, SolrServerException {
        ArrayList<String> allFields = new ArrayList<String>();
        SchemaRequest.Fields listFields = new SchemaRequest.Fields();
        SchemaResponse.FieldsResponse fieldsResponse = (SchemaResponse.FieldsResponse)listFields.process(solrClient);
        List solrFields = fieldsResponse.getFields();
        for (Map field : solrFields) {
            allFields.add((String)field.get("name"));
        }
        return allFields;
    }
}

