/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.context;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.util.Emailer;
import org.intermine.util.ShutdownHook;
import org.intermine.util.Shutdownable;
import org.intermine.web.context.ContextNotInitialisedException;
import org.intermine.web.context.DaemonThreadFactory;
import org.intermine.web.context.EmailerFactory;
import org.intermine.web.context.MailAction;
import org.intermine.web.context.MailDaemon;
import org.intermine.web.logic.ResourceOpener;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.security.KeyStoreBuilder;

public final class InterMineContext
implements Shutdownable {
    private static final Logger LOG = Logger.getLogger(InterMineContext.class);
    private static final int WORKERS = 10;
    private static InterMineAPI im;
    private static Properties webProperties;
    private static WebConfig webConfig;
    private static volatile boolean isInitialised;
    private static Emailer emailer;
    private static final Map<String, Object> ATTRIBUTES;
    private static KeyStore keyStore;
    private static ArrayBlockingQueue<MailAction> mailQueue;
    private static ExecutorService mailService;
    private static ResourceOpener opener;
    private static final String STOPPING_THREAD = "Forcibly stopping thread to avoid memory leak: ";

    private InterMineContext() {
    }

    public static synchronized void initialise(InterMineAPI imApi, Properties webProps, WebConfig wc, ResourceOpener resourceOpener) {
        if (imApi == null || webProps == null || wc == null || resourceOpener == null) {
            throw new NullPointerException("None of the arguments to this method may be null.");
        }
        if (isInitialised) {
            InterMineContext.doShutdown();
        }
        im = imApi;
        webProperties = webProps;
        webConfig = wc;
        opener = resourceOpener;
        emailer = EmailerFactory.getEmailer(webProps);
        mailQueue = new ArrayBlockingQueue(10000);
        mailService = Executors.newCachedThreadPool(new DaemonThreadFactory());
        InterMineContext.startMailerThreads(emailer);
        ShutdownHook.registerObject((Object)new InterMineContext());
        isInitialised = true;
    }

    private static void checkInit() {
        if (!isInitialised) {
            throw new ContextNotInitialisedException("Attempt to access InterMineContext before it has  been initialised");
        }
    }

    public static InterMineAPI getInterMineAPI() {
        InterMineContext.checkInit();
        return im;
    }

    public static WebConfig getWebConfig() {
        InterMineContext.checkInit();
        return webConfig;
    }

    public static Properties getWebProperties() {
        InterMineContext.checkInit();
        return webProperties;
    }

    public static Object getAttribute(String name) {
        return ATTRIBUTES.get(name);
    }

    public static void setAttribute(String name, Object value) {
        ATTRIBUTES.put(name, value);
    }

    public static boolean queueMessage(MailAction action) {
        return mailQueue.offer(action);
    }

    private static void startMailerThreads(Emailer emailer) {
        for (int i = 0; i < 10; ++i) {
            MailDaemon r = new MailDaemon(mailQueue, emailer);
            mailService.submit(r);
        }
    }

    public void shutdown() {
        InterMineContext.checkInit();
        InterMineContext.doShutdown();
    }

    public static void doShutdown() {
        if (mailQueue != null && mailService != null) {
            int leftToSend = mailQueue.size();
            for (int i = 0; i < leftToSend; ++i) {
                MailDaemon r = new MailDaemon(mailQueue, emailer);
                mailService.submit(r);
            }
            mailService.shutdownNow();
        }
        im = null;
        webProperties = null;
        webConfig = null;
        emailer = null;
        keyStore = null;
        mailQueue = null;
        mailService = null;
        isInitialised = false;
    }

    public static KeyStore getKeyStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        InterMineContext.checkInit();
        if (keyStore == null) {
            KeyStoreBuilder builder = new KeyStoreBuilder(InterMineContext.getWebProperties(), opener);
            keyStore = builder.buildKeyStore();
        }
        return keyStore;
    }

    static {
        isInitialised = false;
        ATTRIBUTES = new HashMap<String, Object>();
        keyStore = null;
    }
}

