/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.displayer;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.TypeUtil;
import org.intermine.web.displayer.ReportDisplayer;
import org.intermine.web.logic.config.ReportDisplayerConfig;
import org.intermine.web.logic.config.WebConfig;

public final class DisplayerManager {
    private static DisplayerManager instance = null;
    private Map<String, Map<String, List<ReportDisplayer>>> displayers = new HashMap<String, Map<String, List<ReportDisplayer>>>();
    private static final String DEFAULT_PLACEMENT = "summary";
    protected static final Logger LOG = Logger.getLogger(DisplayerManager.class);

    public static DisplayerManager getInstance(WebConfig webConfig, InterMineAPI im) {
        if (instance == null) {
            instance = new DisplayerManager(webConfig, im);
        }
        return instance;
    }

    private DisplayerManager(WebConfig webConfig, InterMineAPI im) {
        for (ReportDisplayerConfig config : webConfig.getReportDisplayerConfigs()) {
            ReportDisplayer displayer = null;
            try {
                String reportDisplayerName = config.getJavaClass();
                Class clazz = TypeUtil.instantiate((String)reportDisplayerName);
                Constructor m = clazz.getConstructor(ReportDisplayerConfig.class, InterMineAPI.class);
                displayer = (ReportDisplayer)m.newInstance(config, im);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to instantiate displayer for class: " + config.getJavaClass() + " because: " + e));
            }
            if (displayer == null) continue;
            String placement = config.getPlacement();
            if (placement == null) {
                placement = DEFAULT_PLACEMENT;
            }
            HashSet<String> allTypes = new HashSet<String>();
            for (String type : config.getConfiguredTypes()) {
                ClassDescriptor cld = im.getModel().getClassDescriptorByName(type);
                if (cld != null) {
                    allTypes.add(type);
                    for (ClassDescriptor sub : im.getModel().getAllSubs(cld)) {
                        allTypes.add(sub.getUnqualifiedName());
                    }
                    continue;
                }
                LOG.error((Object)("The type " + type + " does not exist, check webconfig-model.xml."));
            }
            for (String type : allTypes) {
                List<ReportDisplayer> placementDisplayers;
                Map<String, List<ReportDisplayer>> typeDisplayers = this.displayers.get(type);
                if (typeDisplayers == null) {
                    typeDisplayers = new HashMap<String, List<ReportDisplayer>>();
                    this.displayers.put(type, typeDisplayers);
                }
                if ((placementDisplayers = typeDisplayers.get(placement)) == null) {
                    placementDisplayers = new ArrayList<ReportDisplayer>();
                    typeDisplayers.put(placement, placementDisplayers);
                }
                placementDisplayers.add(displayer);
            }
        }
    }

    public Set<ReportDisplayer> getAllReportDisplayersForType(String type) {
        HashSet<ReportDisplayer> displayersForType = new HashSet<ReportDisplayer>();
        if (this.displayers.containsKey(type)) {
            for (List<ReportDisplayer> disps : this.displayers.get(type).values()) {
                displayersForType.addAll(disps);
            }
        }
        return displayersForType;
    }

    public Map<String, List<ReportDisplayer>> getReportDisplayersForType(String type) {
        return this.displayers.get(type);
    }

    public ReportDisplayer getReportDisplayerByName(String objectType, String name) {
        for (List<ReportDisplayer> l : this.displayers.get(objectType).values()) {
            for (ReportDisplayer d : l) {
                if (!d.getDisplayerName().equals(name)) continue;
                return d;
            }
        }
        return null;
    }
}

