/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.intermine.objectstore.ObjectStoreException;
import org.intermine.web.uri.InterMineLUI;
import org.intermine.web.uri.InterMineLUIConverter;
import org.intermine.web.uri.InvalidPermanentURLException;

public class PermanentURLFilter
implements Filter {
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpSession session = request.getSession();
        try {
            InterMineLUI permanentURL = new InterMineLUI(request.getRequestURI());
            InterMineLUIConverter urlConverter = new InterMineLUIConverter();
            Integer id = urlConverter.getInterMineID(permanentURL);
            if (id == -1) {
                response.setStatus(404);
                chain.doFilter(req, res);
            } else {
                String redirectURL = request.getContextPath() + "/report.do?id=" + id;
                response.sendRedirect(redirectURL);
            }
        }
        catch (InvalidPermanentURLException ex) {
            chain.doFilter(req, res);
        }
        catch (ObjectStoreException ex) {
            response.setStatus(500);
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

