/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.intermine.api.InterMineAPI;
import org.intermine.api.config.ClassKeyHelper;
import org.intermine.api.results.ResultCell;
import org.intermine.api.results.ResultElement;
import org.intermine.api.types.ClassKeys;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.model.FastPathObject;
import org.intermine.util.DynamicUtil;
import org.intermine.web.logic.bag.BagConverter;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.util.URLGenerator;

public final class PortalHelper {
    private static Map<String, BagConverter> bagConverters = new HashMap<String, BagConverter>();
    private static String portalBaseUrl = null;
    private static final String INTERNAL_REPORT_PAGE = "report.do";
    private static final String EXTERNAL_PORTAL_PAGE = "portal.do";

    private PortalHelper() {
    }

    public static synchronized BagConverter getBagConverter(InterMineAPI im, WebConfig webConfig, String converterClassName) {
        BagConverter bagConverter = bagConverters.get(converterClassName);
        if (bagConverter == null) {
            try {
                Class<?> clazz = Class.forName(converterClassName);
                Constructor<?> constructor = clazz.getConstructor(InterMineAPI.class, WebConfig.class);
                bagConverter = (BagConverter)constructor.newInstance(im, webConfig);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to construct bagconverter for " + converterClassName, e);
            }
            bagConverters.put(converterClassName, bagConverter);
        }
        return bagConverter;
    }

    public static String getAdditionalParameter(HttpServletRequest request, String params) {
        if (StringUtils.isEmpty((String)params)) {
            return null;
        }
        String[] urlFields = params.split("[, ]+");
        String addparameter = null;
        for (String urlField : urlFields) {
            String param = request.getParameter(urlField);
            if (!StringUtils.isNotEmpty((String)param)) continue;
            try {
                addparameter = URLDecoder.decode(param, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error("UTF-8 is not supported?!", e);
            }
        }
        return addparameter;
    }

    public static String generatePortalLink(FastPathObject obj, InterMineAPI im, HttpServletRequest request) {
        ClassKeys classKeys = im.getClassKeys();
        String baseUrl = PortalHelper.getBaseUrl(request);
        return PortalHelper.generatePermaLink(obj, baseUrl, (Map<String, List<FieldDescriptor>>)classKeys);
    }

    public static String generatePortalPath(FastPathObject obj, InterMineAPI im) {
        ClassKeys classKeys = im.getClassKeys();
        return PortalHelper.generatePermaPath(obj, (Map<String, List<FieldDescriptor>>)classKeys);
    }

    public static String generatePermaLink(FastPathObject obj, String baseUrl, Map<String, List<FieldDescriptor>> classKeys) {
        String newBase = null;
        newBase = baseUrl.contains("release") ? baseUrl.replaceFirst("release-\\d*.\\d*", "query") : baseUrl;
        return newBase + PortalHelper.generatePermaPath(obj, classKeys);
    }

    public static String generatePermaPath(FastPathObject obj, Map<String, List<FieldDescriptor>> classKeys) {
        String url = null;
        Object externalId = ClassKeyHelper.getKeyFieldValue((FastPathObject)obj, classKeys);
        if (externalId != null) {
            String clsName = DynamicUtil.getSimpleClass((FastPathObject)obj).getSimpleName();
            StringBuilder sb = new StringBuilder();
            sb.append("/").append(EXTERNAL_PORTAL_PAGE).append("?class=");
            sb.append(clsName);
            sb.append("&externalids=");
            sb.append(PortalHelper.encode(externalId.toString()));
            url = sb.toString();
        }
        return url;
    }

    public static String generateReportLink(ResultElement elem, String baseUrl) {
        return baseUrl + PortalHelper.generateReportPath((ResultCell)elem);
    }

    public static String generateReportPath(ResultCell elem) {
        StringBuilder sb = new StringBuilder();
        sb.append("/").append(INTERNAL_REPORT_PAGE).append("?id=");
        sb.append(String.valueOf(elem.getId()));
        String url = sb.toString();
        return url;
    }

    public static String getBaseUrl(HttpServletRequest request) {
        if (portalBaseUrl == null) {
            portalBaseUrl = new URLGenerator(request).getPermanentBaseURL();
        }
        return portalBaseUrl;
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return s;
        }
    }
}

