/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class SortableMap<K extends Comparable<K>, V extends Comparable<V>>
extends LinkedHashMap<K, V> {
    public SortableMap() {
    }

    public SortableMap(Map<K, V> map) {
        super(map);
    }

    public void sortKeys() {
        this.sortKeys(false, true);
    }

    public void sortKeys(boolean checkNumbers, boolean sortAscending) {
        KeyComparator comparator = new KeyComparator(checkNumbers, sortAscending);
        TreeMap treeMap = new TreeMap(comparator);
        treeMap.putAll(this);
        this.clear();
        this.putAll(treeMap);
    }

    public void sortValues() {
        this.sortValues(false, true);
    }

    public void sortValues(boolean checkNumbers, boolean sortAscending) {
        ValueComparator comparator = new ValueComparator(sortAscending, checkNumbers);
        TreeMap treeMap = new TreeMap(comparator);
        treeMap.putAll(this);
        this.clear();
        this.putAll(treeMap);
    }

    private static <T extends Comparable<T>> int compareThings(boolean checkNumbers, boolean sortAscending, T a, T b) {
        if (checkNumbers) {
            try {
                BigDecimal asNum1 = new BigDecimal(a.toString());
                BigDecimal asNum2 = new BigDecimal(b.toString());
                if (sortAscending) {
                    return asNum1.compareTo(asNum2);
                }
                return asNum2.compareTo(asNum1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (sortAscending) {
            return a.compareTo(b);
        }
        return b.compareTo(a);
    }

    private final class KeyComparator
    implements Comparator<K> {
        private final boolean checkNumbers;
        private final boolean sortAscending;

        private KeyComparator(boolean checkNumbers, boolean sortAscending) {
            this.checkNumbers = checkNumbers;
            this.sortAscending = sortAscending;
        }

        @Override
        public int compare(K key1, K key2) {
            return SortableMap.compareThings(this.checkNumbers, this.sortAscending, key1, key2);
        }
    }

    private final class ValueComparator
    implements Comparator<K> {
        private final boolean sortAscending;
        private final boolean checkNumbers;

        private ValueComparator(boolean sortAscending, boolean checkNumbers) {
            this.sortAscending = sortAscending;
            this.checkNumbers = checkNumbers;
        }

        @Override
        public int compare(K key1, K key2) {
            Comparable value1 = (Comparable)SortableMap.this.get(key1);
            Comparable value2 = (Comparable)SortableMap.this.get(key2);
            if (value1 == null || value2 == null || value1.equals(value2)) {
                return SortableMap.compareThings(this.checkNumbers, this.sortAscending, key1, key2);
            }
            return SortableMap.compareThings(this.checkNumbers, this.sortAscending, value1, value2);
        }
    }
}

