/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.intermine.api.InterMineAPI;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.metadata.Model;
import org.intermine.metadata.StringUtil;
import org.intermine.pathquery.Path;
import org.intermine.pathquery.PathException;
import org.intermine.pathquery.PathQuery;
import org.intermine.util.PropertiesUtil;
import org.intermine.web.context.InterMineContext;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.FieldConfigHelper;
import org.intermine.web.logic.config.Type;
import org.intermine.web.logic.config.WebConfig;
import org.intermine.web.logic.results.WebState;
import org.intermine.web.logic.session.SessionMethods;

public abstract class WebUtil {
    protected static final Logger LOG = Logger.getLogger(WebUtil.class);

    private WebUtil() {
    }

    public static int getIntSessionProperty(HttpSession session, String propertyName, int defaultValue) {
        Properties webProperties = SessionMethods.getWebProperties(session.getServletContext());
        String n = webProperties.getProperty(propertyName);
        int intVal = defaultValue;
        try {
            intVal = Integer.parseInt(n);
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Failed to parse " + propertyName + " property: " + n));
        }
        return intVal;
    }

    public static <V> Map<String, V> shuffle(Map<String, V> map, int max) {
        List<String> keys = new ArrayList<String>(map.keySet());
        Collections.shuffle(keys);
        if (keys.size() > max) {
            keys = keys.subList(0, max);
        }
        HashMap<String, V> returnMap = new HashMap<String, V>();
        for (String key : keys) {
            returnMap.put(key, map.get(key));
        }
        return returnMap;
    }

    public static String getStaticPage(String prefixURLString, String path) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        URL url = new URL(prefixURLString + '/' + path);
        URLConnection connection = url.openConnection();
        InputStream is = connection.getInputStream();
        InputStreamReader reader = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(reader);
        while ((line = br.readLine()) != null) {
            line = line.replaceAll("href=\"([^\"]+)\"", "href=\"showStatic.do?path=$1\"");
            buf.append(line + "\n");
        }
        return buf.toString();
    }

    public static String[] getHelpPage(HttpServletRequest request) {
        HttpSession session = request.getSession();
        ServletContext servletContext = session.getServletContext();
        Properties webProps = SessionMethods.getWebProperties(servletContext);
        WebState webState = SessionMethods.getWebState(request.getSession());
        String pageName = (String)request.getAttribute("pageName");
        String subTab = webState.getSubtab("subtab" + pageName);
        String prop = subTab == null ? webProps.getProperty("help.page." + pageName) : webProps.getProperty("help.page." + pageName + "." + subTab);
        if (prop == null) {
            return new String[0];
        }
        return StringUtil.split((String)prop, (String)":");
    }

    public static List<HeadResource> getHeadResources(String section, Map<String, String> userPreferences) {
        Properties webProperties = InterMineContext.getWebProperties();
        String cdnLocation = webProperties.getProperty("head.cdn.location");
        boolean allowUserOverrides = "true".equals(webProperties.getProperty("head.allow.user.overrides"));
        ArrayList<HeadResource> ret = new ArrayList<HeadResource>();
        for (String type : new String[]{"css", "js"}) {
            String key = String.format("head.%s.%s.", type, section);
            Properties userProps = new Properties();
            userProps.putAll((Map<?, ?>)webProperties);
            if (allowUserOverrides && userPreferences != null) {
                userProps.putAll(userPreferences);
            }
            Properties matches = PropertiesUtil.getPropertiesStartingWith((String)key, (Properties)userProps);
            TreeSet<Object> keys = new TreeSet<Object>(matches.keySet());
            for (Object e : keys) {
                String propName = String.valueOf(e);
                String value = matches.getProperty(propName);
                if (StringUtils.isBlank((String)value)) {
                    LOG.warn((Object)("Head resource configured with blank value: skipping " + propName));
                    continue;
                }
                if (value.startsWith("CDN")) {
                    value = value.replace("CDN", cdnLocation);
                } else if (!value.startsWith("/") && !value.startsWith("http")) {
                    value = String.format("/%s/%s", type, value);
                }
                HeadResource resource = new HeadResource(propName, type, value);
                ret.add(resource);
            }
        }
        return ret;
    }

    public static String formatColumnName(String original) {
        return original.replaceAll("&", "&amp;").replaceAll(" > ", "&nbsp;&gt; ").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String formatPath(String original, HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        InterMineAPI im = SessionMethods.getInterMineAPI(request);
        Model model = im.getModel();
        WebConfig webConfig = SessionMethods.getWebConfig(request);
        return WebUtil.formatPath(original, model, webConfig);
    }

    public static List<String> formatPathQueryView(PathQuery pq, HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        WebConfig webConfig = SessionMethods.getWebConfig(request);
        return WebUtil.formatPathQueryView(pq, webConfig);
    }

    public static List<String> formatPathQueryView(PathQuery pq, WebConfig wc) {
        ArrayList<String> formattedViews = new ArrayList<String>();
        for (String view : pq.getView()) {
            formattedViews.add(WebUtil.formatPathDescription(view, pq, wc));
        }
        return formattedViews;
    }

    public static String formatPath(String original, Model model, WebConfig webConfig) {
        Path viewPath;
        try {
            viewPath = new Path(model, original);
        }
        catch (PathException e) {
            return original;
        }
        return WebUtil.formatPath(viewPath, webConfig);
    }

    public static String formatPath(String pathString, InterMineAPI api, WebConfig webConfig) {
        Path viewPath;
        try {
            viewPath = new Path(api.getModel(), pathString);
        }
        catch (Throwable t) {
            return pathString;
        }
        return WebUtil.formatPath(viewPath, webConfig);
    }

    public static String formatPath(String path, PathQuery pq, WebConfig config) {
        Path viewPath;
        try {
            viewPath = pq.makePath(path);
        }
        catch (Throwable t) {
            return path;
        }
        return WebUtil.formatPath(viewPath, config);
    }

    public static String formatPath(Path viewColumn, WebConfig webConfig) {
        ClassDescriptor cd = viewColumn.getStartClassDescriptor();
        if (viewColumn.isRootPath()) {
            return WebUtil.formatClass(cd, webConfig);
        }
        return WebUtil.formatClass(cd, webConfig) + " > " + WebUtil.formatFieldChain(viewColumn, webConfig);
    }

    public static String formatClass(ClassDescriptor cd, WebConfig config) {
        Type type = config.getTypes().get(cd.getName());
        if (type == null) {
            return Type.getFormattedClassName(cd.getUnqualifiedName());
        }
        return type.getDisplayName();
    }

    public static String formatField(String s, InterMineAPI api, WebConfig webConfig) {
        Path viewPath;
        if (StringUtils.isEmpty((String)s)) {
            return "";
        }
        try {
            viewPath = new Path(api.getModel(), s);
        }
        catch (PathException e) {
            return s;
        }
        return WebUtil.formatField(viewPath, webConfig);
    }

    public static String formatField(Path p, WebConfig webConfig) {
        if (p == null) {
            return "";
        }
        FieldDescriptor fd = p.getEndFieldDescriptor();
        if (fd == null) {
            return "";
        }
        ClassDescriptor cld = fd.isAttribute() ? p.getLastClassDescriptor() : p.getSecondLastClassDescriptor();
        FieldConfig fc = FieldConfigHelper.getFieldConfig(webConfig, cld, fd);
        if (fc != null) {
            return fc.getDisplayName();
        }
        return FieldConfig.getFormattedName(fd.getName());
    }

    public static String formatFieldChain(Path p, WebConfig config) {
        String pathString;
        FieldConfig fcg;
        Type type;
        if (p == null) {
            return "";
        }
        ClassDescriptor cd = p.getStartClassDescriptor();
        if (p.endIsAttribute() && (type = config.getTypes().get(cd.getName())) != null && (fcg = type.getFieldConfig((pathString = p.getNoConstraintsString()).substring(pathString.indexOf(".") + 1))) != null) {
            return fcg.getDisplayName();
        }
        List elems = p.getElements();
        String firstField = (String)elems.get(0);
        if (firstField == null) {
            return "";
        }
        FieldDescriptor fd = cd.getFieldDescriptorByName(firstField);
        FieldConfig fc = FieldConfigHelper.getFieldConfig(config, cd, fd);
        String thisPart = "";
        thisPart = fc != null ? fc.getDisplayName() : FieldConfig.getFormattedName(fd.getName());
        if (elems.size() > 1) {
            Path newPath;
            String root = ((Path)p.decomposePath().get(1)).getLastClassDescriptor().getUnqualifiedName();
            String[] parts = p.toString().split("\\.");
            int start = Math.min(2, parts.length - 1);
            String fields = StringUtils.join((Object[])Arrays.copyOfRange(parts, start, parts.length), (String)".");
            String nextPathString = root + "." + fields;
            try {
                newPath = new Path(p.getModel(), nextPathString);
            }
            catch (PathException e) {
                newPath = null;
            }
            return thisPart + " > " + WebUtil.formatFieldChain(newPath, config);
        }
        return thisPart;
    }

    public static String formatFieldChain(String s, InterMineAPI api, WebConfig webConfig) {
        String fullPath = WebUtil.formatPath(s, api.getModel(), webConfig);
        if (StringUtils.isEmpty((String)fullPath)) {
            return fullPath;
        }
        int idx = fullPath.indexOf(">");
        if (idx != -1) {
            return fullPath.substring(idx + 1);
        }
        return fullPath;
    }

    private static String replaceDescribedPart(String s, Map<String, String> descriptions) {
        String retval = descriptions.get(s);
        if (retval == null) {
            int lastDot = s.lastIndexOf(46);
            if (lastDot == -1) {
                return s;
            }
            return WebUtil.replaceDescribedPart(s.substring(0, lastDot), descriptions) + " > " + s.substring(lastDot + 1);
        }
        return retval;
    }

    public static String formatPathDescription(String s, PathQuery pq, WebConfig config) {
        Path p;
        try {
            p = pq.makePath(s);
        }
        catch (PathException e) {
            return WebUtil.formatPath(s, pq.getModel(), config);
        }
        return WebUtil.formatPathDescription(p, pq, config);
    }

    public static boolean contains(Collection<?> things, Object o) {
        return things.contains(o);
    }

    public static boolean containsKey(Map<?, ?> mapping, Object o) {
        return mapping.containsKey(o);
    }

    public static String formatPathDescription(Path p, PathQuery pq, WebConfig config) {
        Map descriptions = pq.getDescriptions();
        String withLabels = WebUtil.formatPath(p, config);
        List<String> labeledParts = Arrays.asList(StringUtils.splitByWholeSeparator((String)withLabels, (String)" > "));
        if (descriptions.isEmpty()) {
            return StringUtils.join(labeledParts, (String)" > ");
        }
        String withReplaceMents = WebUtil.replaceDescribedPart(p.getNoConstraintsString(), descriptions);
        List<String> originalParts = Arrays.asList(StringUtils.split((String)p.getNoConstraintsString(), (char)'.'));
        int originalPartsSize = originalParts.size();
        List<String> replacedParts = Arrays.asList(StringUtils.splitByWholeSeparator((String)withReplaceMents, (String)" > "));
        int replacedSize = replacedParts.size();
        int partsToKeepFromOriginal = 0;
        int partsToTakeFromReplaced = replacedSize;
        for (int i = 0; i < originalPartsSize; ++i) {
            String fromReplacement;
            String fromOriginal = originalParts.get(originalPartsSize - (i + 1));
            int replaceMentsIndex = replacedSize - (i + 1);
            String string = fromReplacement = replaceMentsIndex > 0 ? replacedParts.get(replaceMentsIndex) : null;
            if (fromOriginal == null || !fromOriginal.equals(fromReplacement)) continue;
            ++partsToKeepFromOriginal;
            --partsToTakeFromReplaced;
        }
        ArrayList<String> returners = new ArrayList<String>();
        if (partsToTakeFromReplaced > 0) {
            returners.addAll(replacedParts.subList(0, partsToTakeFromReplaced));
        }
        if (partsToKeepFromOriginal > 0) {
            int start = Math.max(0, labeledParts.size() - partsToKeepFromOriginal);
            int end = start + partsToKeepFromOriginal - (originalPartsSize - labeledParts.size());
            returners.addAll(labeledParts.subList(start, end));
        }
        return StringUtils.join(returners, (String)" > ");
    }

    public static boolean hasValidPath(Object obj, String path, InterMineAPI api) {
        try {
            Model m = api.getModel();
            Set clds = m.getClassDescriptorsForClass(obj.getClass());
            Iterator iterator = clds.iterator();
            if (iterator.hasNext()) {
                ClassDescriptor cd = (ClassDescriptor)iterator.next();
                new Path(api.getModel(), cd.getUnqualifiedName() + "." + path);
                return true;
            }
        }
        catch (PathException pathException) {
            // empty catch block
        }
        return false;
    }

    public static final class HeadResource {
        private final String type;
        private final String url;
        private final String key;

        private HeadResource(String key, String type, String url) {
            this.key = key;
            this.type = type;
            this.url = url;
        }

        public String getKey() {
            return this.key;
        }

        public String getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public boolean getIsRelative() {
            return this.url.startsWith("/");
        }

        public String toString() {
            return String.format("HeadResouce [type = %s, url = %s]", this.type, this.url);
        }
    }
}

