/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.aspects;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;
import org.intermine.web.logic.aspects.Aspect;
import org.xml.sax.SAXException;

public final class AspectBinding {
    private static final Logger LOG = Logger.getLogger(AspectBinding.class);

    private AspectBinding() {
    }

    public static Map<String, Aspect> unmarshal(Reader reader) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.addObjectCreate("aspects", "java.util.ArrayList");
        digester.addObjectCreate("aspects/aspect", "org.intermine.web.logic.aspects.Aspect");
        digester.addSetProperties("aspects/aspect");
        digester.addCallMethod("aspects/aspect/subtitle", "setSubTitle", 0);
        digester.addCallMethod("aspects/aspect/icon-image", "setIconImage", 0);
        digester.addCallMethod("aspects/aspect/large-image", "setLargeImage", 0);
        digester.addCallMethod("aspects/aspect/tile-name", "setTileName", 0);
        digester.addCallMethod("aspects/aspect/intro-text", "setIntroText", 0);
        digester.addCallMethod("aspects/aspect/starting-points", "setStartingPoints", 0);
        digester.addObjectCreate("aspects/aspect/aspect-source", "org.intermine.web.logic.aspects.AspectSource");
        digester.addSetProperties("aspects/aspect/aspect-source");
        digester.addSetNext("aspects/aspect/aspect-source", "addAspectSource", "org.intermine.web.logic.aspects.AspectSource");
        digester.addSetNext("aspects/aspect", "add", "java.lang.Object");
        List list = (List)digester.parse(reader);
        if (list == null) {
            LOG.error((Object)"Failed to unmashal aspects (digester returned null)");
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Aspect> map = new LinkedHashMap<String, Aspect>();
        for (Aspect set : list) {
            map.put(set.getName(), set);
        }
        return map;
    }

    public static Map<String, Aspect> unmarhsal(InputStream is) throws IOException, SAXException {
        return AspectBinding.unmarshal(new InputStreamReader(is));
    }
}

