/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.config;

import org.apache.commons.lang.StringUtils;
import org.intermine.web.logic.config.Type;

public class FieldConfig {
    private String fieldExpr;
    private boolean doNotTruncate;
    private boolean escapeXml = true;
    private boolean hide = false;
    private boolean showInSummary = true;
    private boolean outerInSummary = false;
    private boolean showInInlineCollection = true;
    private boolean showInResults = true;
    private boolean sectionOnRight;
    private String sectionTitle;
    private boolean openByDefault;
    private String fieldExporter;
    private String displayer;
    private String label = null;
    private Type parent = null;
    private Boolean showInListAnalysisPreviewTable = false;
    private boolean showInQB = true;

    public void setShowInListAnalysisPreviewTable(Boolean showInListAnalysisPreviewTable) {
        this.showInListAnalysisPreviewTable = showInListAnalysisPreviewTable;
    }

    public Boolean getShowInListAnalysisPreviewTable() {
        return this.showInListAnalysisPreviewTable;
    }

    public String getDisplayName() {
        if (this.label != null) {
            return this.label;
        }
        return this.getFormattedName();
    }

    public String getFormattedName() {
        return FieldConfig.getFormattedName(this.fieldExpr);
    }

    public static String getFormattedName(String name) {
        String[] parts = StringUtils.splitByCharacterTypeCamelCase((String)name);
        Object[] ucFirstParts = new String[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            ucFirstParts[i] = StringUtils.capitalize((String)parts[i]);
        }
        return StringUtils.join((Object[])ucFirstParts, (String)" ");
    }

    public void setClassConfig(Type ccf) {
        this.parent = ccf;
    }

    public Type getClassConfig() {
        return this.parent;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setFieldExpr(String fieldExpr) {
        this.fieldExpr = fieldExpr;
    }

    public String getFieldExpr() {
        return this.fieldExpr;
    }

    public void setShowInQB(boolean showInQB) {
        this.showInQB = showInQB;
    }

    public boolean getShowInQB() {
        return this.showInQB;
    }

    public boolean getIsDottedPath() {
        return this.fieldExpr.lastIndexOf(".") >= 0;
    }

    public void setDoNotTruncate(boolean doNotTruncate) {
        this.doNotTruncate = doNotTruncate;
    }

    public boolean getDoNotTruncate() {
        return this.doNotTruncate;
    }

    public void setEscapeXml(boolean escapeXml) {
        this.escapeXml = escapeXml;
    }

    public boolean getEscapeXml() {
        return this.escapeXml;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public boolean getHide() {
        return this.hide;
    }

    public void setShowInSummary(boolean showInSummary) {
        this.showInSummary = showInSummary;
    }

    public boolean getShowInSummary() {
        return this.showInSummary;
    }

    public boolean getOuterInSummary() {
        return this.outerInSummary;
    }

    public void setOuterInSummary(boolean outerInSummary) {
        this.outerInSummary = outerInSummary;
    }

    public void setShowInInlineCollection(boolean showInInlineCollection) {
        this.showInInlineCollection = showInInlineCollection;
    }

    public boolean getShowInInlineCollection() {
        return this.showInInlineCollection;
    }

    public void setShowInResults(boolean showInResults) {
        this.showInResults = showInResults;
    }

    public boolean getShowInResults() {
        return this.showInResults;
    }

    public void setFieldExporter(String fieldExporter) {
        this.fieldExporter = fieldExporter;
    }

    public String getFieldExporter() {
        return this.fieldExporter;
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof FieldConfig) {
            FieldConfig otherFc = (FieldConfig)otherObject;
            if (otherFc.fieldExporter == null && this.fieldExporter != null || otherFc.fieldExporter != null && this.fieldExporter == null) {
                return false;
            }
            if (otherFc.fieldExporter != null && !otherFc.fieldExporter.equals(this.fieldExporter)) {
                return false;
            }
            return otherFc.fieldExpr.equals(this.fieldExpr) && otherFc.showInSummary == this.showInSummary && otherFc.outerInSummary == this.outerInSummary && otherFc.showInInlineCollection == this.showInInlineCollection && otherFc.showInResults == this.showInResults;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "<fieldconfig fieldExpr=\"" + this.fieldExpr + "\" displayer=\"" + this.displayer + "\" doNotTruncate=\"" + this.doNotTruncate + "\" showInSummary=\"" + this.showInSummary + "\" outerInSummary=\"" + this.outerInSummary + "\" showInInlineCollection=\"" + this.showInInlineCollection + "\" showInResults=\"" + this.showInResults + "\" escapeXml=\"" + this.escapeXml + "\"" + (this.fieldExporter == null ? "" : " fieldExporter=\"" + this.fieldExporter + "\"") + (this.label == null ? "" : " label=\"" + this.label + "\"") + "/>";
    }

    public boolean isOpenByDefault() {
        return this.openByDefault;
    }

    public void setOpenByDefault(boolean openByDefault) {
        this.openByDefault = openByDefault;
    }

    public boolean isSectionOnRight() {
        return this.sectionOnRight;
    }

    public void setSectionOnRight(boolean sectionOnRight) {
        this.sectionOnRight = sectionOnRight;
    }

    public String getSectionTitle() {
        return this.sectionTitle;
    }

    public void setSectionTitle(String sectionTitle) {
        this.sectionTitle = sectionTitle;
    }

    public String getDisplayer() {
        return this.displayer;
    }

    public void setDisplayer(String displayer) {
        this.displayer = displayer;
    }
}

