/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.config;

import java.util.ArrayList;
import java.util.List;
import org.intermine.metadata.AttributeDescriptor;
import org.intermine.metadata.ClassDescriptor;
import org.intermine.metadata.FieldDescriptor;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.Type;
import org.intermine.web.logic.config.WebConfig;

public final class FieldConfigHelper {
    private FieldConfigHelper() {
    }

    public static List<FieldConfig> getClassFieldConfigs(WebConfig webConfig, ClassDescriptor cd) {
        if (webConfig == null) {
            throw new NullPointerException("webConfig must not be null");
        }
        if (cd == null) {
            throw new NullPointerException("class descriptor 'cd' must not be null");
        }
        Type type = webConfig.getTypes().get(cd.getName());
        ArrayList<Object> fieldConfigs = null;
        if (type != null && (fieldConfigs = new ArrayList<FieldConfig>(type.getFieldConfigs())).size() > 0) {
            return fieldConfigs;
        }
        fieldConfigs = new ArrayList();
        for (AttributeDescriptor ad : cd.getAllAttributeDescriptors()) {
            String attrName = ad.getName();
            if ("id".equals(attrName)) continue;
            FieldConfig fc = new FieldConfig();
            fc.setShowInInlineCollection(true);
            fc.setShowInResults(true);
            fc.setFieldExpr(attrName);
            fc.setClassConfig(type);
            fieldConfigs.add(fc);
        }
        return fieldConfigs;
    }

    public static FieldConfig getFieldConfig(WebConfig webConfig, FieldDescriptor fd) {
        ClassDescriptor cld = fd.getClassDescriptor();
        return FieldConfigHelper.getFieldConfig(webConfig, cld, fd);
    }

    public static FieldConfig getFieldConfig(WebConfig webConfig, ClassDescriptor cld, FieldDescriptor fd) {
        List<FieldConfig> fcs = FieldConfigHelper.getClassFieldConfigs(webConfig, cld);
        for (FieldConfig fc : fcs) {
            String fieldExpr;
            if (fc == null || (fieldExpr = fc.getFieldExpr()) == null || !fieldExpr.equals(fd.getName())) continue;
            return fc;
        }
        for (ClassDescriptor parent : cld.getSuperDescriptors()) {
            FieldConfig fc = FieldConfigHelper.getFieldConfig(webConfig, parent, fd);
            if (fc == null) continue;
            return fc;
        }
        return null;
    }
}

