/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class HeaderConfigTitle {
    private HashMap<String, List<TitlePart>> titleParts = new HashMap();
    private Boolean appendConfig = false;
    private Integer numberOfMainTitlesToShow = Integer.MAX_VALUE;
    public static final String MAIN = "main";
    public static final String SUB = "sub";
    public static final String[] TYPES = new String[]{"main", "sub"};

    public void setMainTitles(String mainTitles) {
        this.setTitles(mainTitles, MAIN);
    }

    public void setSubTitles(String subTitles) {
        this.setTitles(subTitles, SUB);
    }

    public void setNumberOfMainTitlesToShow(Integer maxNumber) {
        this.numberOfMainTitlesToShow = maxNumber;
    }

    public Integer getNumberOfMainTitlesToShow() {
        return this.numberOfMainTitlesToShow;
    }

    private void setTitles(String titles, String titlePart) {
        List<TitlePart> titleFields = this.titleParts.get(titlePart);
        if (titleFields == null) {
            titleFields = new ArrayList<TitlePart>();
            this.titleParts.put(titlePart, titleFields);
        }
        StringTokenizer st = new StringTokenizer(titles, "|");
        while (st.hasMoreTokens()) {
            String field = st.nextToken();
            TitlePart tp = new TitlePart(field);
            if (titleFields.contains(tp)) continue;
            titleFields.add(tp);
        }
    }

    public void addTitleParts(HashMap<String, List<TitlePart>> partsToAdd) {
        this.titleParts.putAll(partsToAdd);
    }

    public HashMap<String, List<TitlePart>> getTitles() {
        return this.titleParts;
    }

    public void setAppendConfig(Boolean value) {
        this.appendConfig = value;
    }

    public Boolean getAppendConfig() {
        return this.appendConfig;
    }

    public class TitlePart {
        private final String path;
        private String prefix = "";
        private String suffix = "";

        TitlePart(String styledPath) {
            char first = styledPath.charAt(0);
            char last = styledPath.charAt(styledPath.length() - 1);
            if (first == '[' && last == ']') {
                this.prefix = "" + first;
                this.suffix = "" + last;
            } else if (first == '*' && first == last) {
                this.prefix = "<i>";
                this.suffix = "</i>";
            }
            this.path = styledPath.replaceAll("[^a-zA-Z.]", "");
        }

        public String getPath() {
            return this.path;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TitlePart) {
                return ((TitlePart)obj).path.equals(this.path);
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }
}

