/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.intermine.metadata.TypeUtil;
import org.intermine.web.logic.config.Displayer;
import org.intermine.web.logic.config.FieldConfig;
import org.intermine.web.logic.config.HeaderConfigLink;
import org.intermine.web.logic.config.HeaderConfigTitle;
import org.intermine.web.logic.config.InlineListConfig;
import org.intermine.web.logic.widget.config.WidgetConfig;

public class Type {
    private String fieldName;
    private String className;
    private Map<String, FieldConfig> fieldConfigMap = new LinkedHashMap<String, FieldConfig>();
    private ListOrderedSet longDisplayers = new ListOrderedSet();
    private ListOrderedSet bagDisplayers = new ListOrderedSet();
    private LinkedList<WidgetConfig> widgets = new LinkedList();
    private Displayer tableDisplayer;
    private Map<String, List<Displayer>> aspectDisplayers = new HashMap<String, List<Displayer>>();
    private LinkedList<InlineListConfig> inlineLists = new LinkedList();
    private HeaderConfigTitle headerConfigTitle;
    private HeaderConfigLink headerConfigLink;
    private String label = null;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDisplayName() {
        if (this.label != null) {
            return this.label;
        }
        return this.getFormattedClassName();
    }

    public String getFormattedClassName() {
        return Type.getFormattedClassName(this.className);
    }

    public static String getFormattedClassName(String nameOfClass) {
        String unqualifiedName = TypeUtil.unqualifiedName((String)nameOfClass);
        Object[] parts = StringUtils.splitByCharacterTypeCamelCase((String)unqualifiedName);
        String[] newParts = new String[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            newParts[i] = StringUtils.capitalize((String)parts[i]);
        }
        return StringUtils.join((Object[])parts, (String)" ");
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public String getUnqualifiedClassName() {
        return TypeUtil.unqualifiedName((String)this.className);
    }

    public void addFieldConfig(FieldConfig df) {
        this.fieldConfigMap.put(df.getFieldExpr(), df);
        df.setClassConfig(this);
    }

    public Collection<FieldConfig> getFieldConfigs() {
        return Collections.unmodifiableCollection(this.fieldConfigMap.values());
    }

    public Map<String, FieldConfig> getFieldConfigMap() {
        return Collections.unmodifiableMap(this.fieldConfigMap);
    }

    public FieldConfig getFieldConfig(String fieldName) {
        return this.fieldConfigMap.get(fieldName);
    }

    public void addLongDisplayer(Displayer disp) {
        this.longDisplayers.add((Object)disp);
        String[] aspects = StringUtils.isEmpty((String)disp.getAspects()) ? new String[]{""} : StringUtils.split((String)disp.getAspects(), (char)',');
        for (int i = 0; i < aspects.length; ++i) {
            String aspect = aspects[i].trim();
            List<Displayer> displayers = this.aspectDisplayers.get(aspect);
            if (displayers == null) {
                displayers = new ArrayList<Displayer>();
                this.aspectDisplayers.put(aspect, displayers);
            }
            displayers.add(disp);
        }
    }

    public void addHeaderConfigTitle(HeaderConfigTitle headerConfig) {
        this.headerConfigTitle = headerConfig;
    }

    public HeaderConfigTitle getHeaderConfigTitle() {
        return this.headerConfigTitle;
    }

    public void addHeaderConfigLink(HeaderConfigLink headerConfig) {
        this.headerConfigLink = headerConfig;
    }

    public HeaderConfigLink getHeaderConfigLink() {
        return this.headerConfigLink;
    }

    public void addInlineList(InlineListConfig listConfig) {
        this.inlineLists.add(listConfig);
    }

    public void addBagDisplayer(Displayer disp) {
        this.bagDisplayers.add((Object)disp);
    }

    public LinkedList<WidgetConfig> getWidgets() {
        return this.widgets;
    }

    public void setWidgets(LinkedList widgets) {
        this.widgets = widgets;
    }

    public synchronized void addWidget(WidgetConfig widget) {
        this.widgets.add(widget);
    }

    public void setTableDisplayer(Displayer disp) {
        this.tableDisplayer = disp;
    }

    public Set<? extends Object> getLongDisplayers() {
        return Collections.unmodifiableSet(this.longDisplayers);
    }

    public List<InlineListConfig> getInlineListConfig() {
        return this.inlineLists;
    }

    public Set<? extends Object> getBagDisplayers() {
        return Collections.unmodifiableSet(this.bagDisplayers);
    }

    public Displayer getTableDisplayer() {
        return this.tableDisplayer;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Type)) {
            return false;
        }
        Type typeObj = (Type)obj;
        return this.fieldConfigMap.equals(typeObj.fieldConfigMap) && this.longDisplayers.equals((Object)typeObj.longDisplayers) && ObjectUtils.equals((Object)this.tableDisplayer, (Object)typeObj.tableDisplayer);
    }

    public int hashCode() {
        int hash = this.fieldConfigMap.hashCode() + 3 * this.longDisplayers.hashCode();
        if (this.tableDisplayer != null) {
            hash += 5 * this.tableDisplayer.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<class className=\"" + this.className + "\"");
        if (this.fieldName != null) {
            sb.append(" fieldName=\"" + this.fieldName + "\"");
        }
        if (this.label != null) {
            sb.append(" label=\"" + this.label + "\"");
        }
        sb.append(">\n");
        sb.append("\t<fieldconfigs>\n");
        for (FieldConfig fc : this.getFieldConfigs()) {
            sb.append("\t\t" + fc.toString() + "\n");
        }
        sb.append("\t</fieldconfigs>\n");
        if (this.tableDisplayer != null) {
            sb.append(this.tableDisplayer.toString("tabledisplayer"));
        }
        sb.append("\t<longdisplayers>\n");
        Iterator iter = this.longDisplayers.iterator();
        while (iter.hasNext()) {
            sb.append("\t\t" + iter.next().toString() + "\n");
        }
        sb.append("\t</longdisplayers>\n");
        sb.append("</class>");
        return sb.toString();
    }

    public Map<String, List<Displayer>> getAspectDisplayers() {
        return this.aspectDisplayers;
    }

    public void setAspectDisplayers(Map<String, List<Displayer>> aspectDisplayers) {
        this.aspectDisplayers = aspectDisplayers;
    }

    public String getMainTitles() {
        return null;
    }

    public String getSubTitles() {
        return null;
    }
}

