/*
 * Decompiled with CFR 0.152.
 */
package org.intermine.web.logic.export;

import javax.servlet.http.HttpServletResponse;

public final class ResponseUtil {
    private ResponseUtil() {
    }

    public static void setTabHeader(HttpServletResponse response, String fileName) {
        ResponseUtil.setNoCache(response);
        ResponseUtil.setTabContentType(response);
        ResponseUtil.setFileName(response, fileName);
    }

    public static void setCSVHeader(HttpServletResponse response, String fileName) {
        ResponseUtil.setNoCache(response);
        ResponseUtil.setCSVContentType(response);
        ResponseUtil.setFileName(response, fileName);
    }

    public static void setXMLHeader(HttpServletResponse response, String fileName) {
        ResponseUtil.setNoCache(response);
        ResponseUtil.setXMLContentType(response);
        ResponseUtil.setFileName(response, fileName);
    }

    public static void setPlainTextHeader(HttpServletResponse response, String fileName) {
        ResponseUtil.setNoCache(response);
        ResponseUtil.setPlainTextContentType(response);
        ResponseUtil.setFileName(response, fileName);
    }

    public static void setGzippedHeader(HttpServletResponse response, String fileName) {
        ResponseUtil.setNoCache(response);
        ResponseUtil.setGzippedContentType(response);
        ResponseUtil.setFileName(response, fileName);
    }

    public static void setJSONHeader(HttpServletResponse response, String filename) {
        ResponseUtil.setJSONHeader(response, filename, false);
    }

    public static void setJSONHeader(HttpServletResponse response, String filename, boolean isJSONP) {
        if (isJSONP) {
            ResponseUtil.setJSONPHeader(response, filename);
        } else {
            ResponseUtil.setJSONContentType(response);
            ResponseUtil.setFileName(response, filename);
            ResponseUtil.setNoCache(response);
        }
    }

    public static void setJSONSchemaHeader(HttpServletResponse response, String filename) {
        ResponseUtil.setJSONSchemaContentType(response);
        ResponseUtil.setFileName(response, filename);
        ResponseUtil.setNoCache(response);
    }

    public static void setJSONPHeader(HttpServletResponse response, String filename) {
        ResponseUtil.setJSONPContentType(response);
        ResponseUtil.setFileName(response, filename);
        ResponseUtil.setNoCache(response);
    }

    public static void setNTriplesHeader(HttpServletResponse response, String filename) {
        ResponseUtil.setPlainTextContentType(response);
        ResponseUtil.setFileName(response, filename);
        ResponseUtil.setNoCache(response);
    }

    public static void setRDFHeader(HttpServletResponse response, String filename) {
        ResponseUtil.setRDFXMLContentType(response);
        ResponseUtil.setFileName(response, filename);
        ResponseUtil.setNoCache(response);
    }

    public static void setCustomTypeHeader(HttpServletResponse response, String fileName, String contentType) {
        ResponseUtil.setNoCache(response);
        ResponseUtil.setCustomContentType(response, contentType);
        ResponseUtil.setFileName(response, fileName);
    }

    public static void setNoCache(HttpServletResponse response) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "must-revalidate, max-age=0");
    }

    public static void setNoCacheEnforced(HttpServletResponse response) {
        response.setHeader("Cache-Control", "max-age=0, must-revalidate, no-store, no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "Wed, 11 Jan 1984 05:00:00 GMT");
    }

    public static void setTabContentType(HttpServletResponse response) {
        response.setContentType("text/tab-separated-values");
        response.setCharacterEncoding("UTF-8");
    }

    public static void setCSVContentType(HttpServletResponse response) {
        response.setContentType("text/comma-separated-values");
        response.setCharacterEncoding("UTF-8");
    }

    public static void setPlainTextContentType(HttpServletResponse response) {
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
    }

    public static void setXMLContentType(HttpServletResponse response) {
        response.setContentType("application/xml");
        response.setCharacterEncoding("UTF-8");
    }

    public static void setHTMLContentType(HttpServletResponse response) {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
    }

    public static void setGzippedContentType(HttpServletResponse response) {
        response.setContentType("application/octet-stream");
    }

    public static void setCustomContentType(HttpServletResponse response, String contentType) {
        response.setContentType(contentType);
    }

    public static void setFileName(HttpServletResponse response, String fileName) {
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
    }

    public static void setJSONContentType(HttpServletResponse response) {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
    }

    public static void setJSONSchemaContentType(HttpServletResponse response) {
        response.setContentType("application/schema+json");
        response.setCharacterEncoding("UTF-8");
    }

    public static void setJSONPContentType(HttpServletResponse response) {
        response.setContentType("application/javascript");
        response.setCharacterEncoding("UTF-8");
    }

    public static void setRDFXMLContentType(HttpServletResponse response) {
        response.setContentType("application/rdf+xml");
        response.setCharacterEncoding("UTF-8");
    }
}

